/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.Type;
import software.amazon.awssdk.services.glacier.transform.GranteeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Grantee
implements StructuredPojo,
ToCopyableBuilder<Builder, Grantee> {
    private final String type;
    private final String displayName;
    private final String uri;
    private final String id;
    private final String emailAddress;

    private Grantee(BuilderImpl builder) {
        this.type = builder.type;
        this.displayName = builder.displayName;
        this.uri = builder.uri;
        this.id = builder.id;
        this.emailAddress = builder.emailAddress;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String displayName() {
        return this.displayName;
    }

    public String uri() {
        return this.uri;
    }

    public String id() {
        return this.id;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.emailAddress(), other.emailAddress());
    }

    public String toString() {
        return ToString.builder((String)"Grantee").add("Type", (Object)this.typeAsString()).add("DisplayName", (Object)this.displayName()).add("URI", (Object)this.uri()).add("ID", (Object)this.id()).add("EmailAddress", (Object)this.emailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "URI": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "ID": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GranteeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String displayName;
        private String uri;
        private String id;
        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            this.type(model.type);
            this.displayName(model.displayName);
            this.uri(model.uri);
            this.id(model.id);
            this.emailAddress(model.emailAddress);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getURI() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setURI(String uri) {
            this.uri = uri;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public Grantee build() {
            return new Grantee(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Grantee> {
        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder displayName(String var1);

        public Builder uri(String var1);

        public Builder id(String var1);

        public Builder emailAddress(String var1);
    }
}

