/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.EncryptionType;
import software.amazon.awssdk.services.glacier.transform.EncryptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Encryption
implements StructuredPojo,
ToCopyableBuilder<Builder, Encryption> {
    private final String encryptionType;
    private final String kmsKeyId;
    private final String kmsContext;

    private Encryption(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsContext = builder.kmsContext;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String kmsContext() {
        return this.kmsContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption)obj;
        return Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.kmsContext(), other.kmsContext());
    }

    public String toString() {
        return ToString.builder((String)"Encryption").add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KMSKeyId", (Object)this.kmsKeyId()).add("KMSContext", (Object)this.kmsContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "KMSContext": {
                return Optional.ofNullable(clazz.cast(this.kmsContext()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionType;
        private String kmsKeyId;
        private String kmsContext;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            this.encryptionType(model.encryptionType);
            this.kmsKeyId(model.kmsKeyId);
            this.kmsContext(model.kmsContext);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKMSKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKMSKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getKMSContext() {
            return this.kmsContext;
        }

        @Override
        public final Builder kmsContext(String kmsContext) {
            this.kmsContext = kmsContext;
            return this;
        }

        public final void setKMSContext(String kmsContext) {
            this.kmsContext = kmsContext;
        }

        public Encryption build() {
            return new Encryption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Encryption> {
        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder kmsKeyId(String var1);

        public Builder kmsContext(String var1);
    }
}

