/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRule;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRulesListCopier;
import software.amazon.awssdk.services.glacier.transform.DataRetrievalPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataRetrievalPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, DataRetrievalPolicy> {
    private final List<DataRetrievalRule> rules;

    private DataRetrievalPolicy(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<DataRetrievalRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalPolicy)) {
            return false;
        }
        DataRetrievalPolicy other = (DataRetrievalPolicy)obj;
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"DataRetrievalPolicy").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataRetrievalPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataRetrievalRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataRetrievalPolicy model) {
            this.rules(model.rules);
        }

        public final Collection<DataRetrievalRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(DataRetrievalRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<DataRetrievalRule> rules) {
            this.rules = DataRetrievalRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(DataRetrievalRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<DataRetrievalRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (DataRetrievalRule)((DataRetrievalRule.Builder)DataRetrievalRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<DataRetrievalRule.BuilderImpl> rules) {
            this.rules = DataRetrievalRulesListCopier.copyFromBuilder(rules);
        }

        public DataRetrievalPolicy build() {
            return new DataRetrievalPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataRetrievalPolicy> {
        public Builder rules(Collection<DataRetrievalRule> var1);

        public Builder rules(DataRetrievalRule ... var1);

        public Builder rules(Consumer<DataRetrievalRule.Builder> ... var1);
    }
}

