/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.FileHeaderInfo;
import software.amazon.awssdk.services.glacier.transform.CSVInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CSVInput
implements StructuredPojo,
ToCopyableBuilder<Builder, CSVInput> {
    private final String fileHeaderInfo;
    private final String comments;
    private final String quoteEscapeCharacter;
    private final String recordDelimiter;
    private final String fieldDelimiter;
    private final String quoteCharacter;

    private CSVInput(BuilderImpl builder) {
        this.fileHeaderInfo = builder.fileHeaderInfo;
        this.comments = builder.comments;
        this.quoteEscapeCharacter = builder.quoteEscapeCharacter;
        this.recordDelimiter = builder.recordDelimiter;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.quoteCharacter = builder.quoteCharacter;
    }

    public FileHeaderInfo fileHeaderInfo() {
        return FileHeaderInfo.fromValue(this.fileHeaderInfo);
    }

    public String fileHeaderInfoAsString() {
        return this.fileHeaderInfo;
    }

    public String comments() {
        return this.comments;
    }

    public String quoteEscapeCharacter() {
        return this.quoteEscapeCharacter;
    }

    public String recordDelimiter() {
        return this.recordDelimiter;
    }

    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String quoteCharacter() {
        return this.quoteCharacter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileHeaderInfoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comments());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteEscapeCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteCharacter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVInput)) {
            return false;
        }
        CSVInput other = (CSVInput)obj;
        return Objects.equals(this.fileHeaderInfoAsString(), other.fileHeaderInfoAsString()) && Objects.equals(this.comments(), other.comments()) && Objects.equals(this.quoteEscapeCharacter(), other.quoteEscapeCharacter()) && Objects.equals(this.recordDelimiter(), other.recordDelimiter()) && Objects.equals(this.fieldDelimiter(), other.fieldDelimiter()) && Objects.equals(this.quoteCharacter(), other.quoteCharacter());
    }

    public String toString() {
        return ToString.builder((String)"CSVInput").add("FileHeaderInfo", (Object)this.fileHeaderInfoAsString()).add("Comments", (Object)this.comments()).add("QuoteEscapeCharacter", (Object)this.quoteEscapeCharacter()).add("RecordDelimiter", (Object)this.recordDelimiter()).add("FieldDelimiter", (Object)this.fieldDelimiter()).add("QuoteCharacter", (Object)this.quoteCharacter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileHeaderInfo": {
                return Optional.ofNullable(clazz.cast(this.fileHeaderInfoAsString()));
            }
            case "Comments": {
                return Optional.ofNullable(clazz.cast(this.comments()));
            }
            case "QuoteEscapeCharacter": {
                return Optional.ofNullable(clazz.cast(this.quoteEscapeCharacter()));
            }
            case "RecordDelimiter": {
                return Optional.ofNullable(clazz.cast(this.recordDelimiter()));
            }
            case "FieldDelimiter": {
                return Optional.ofNullable(clazz.cast(this.fieldDelimiter()));
            }
            case "QuoteCharacter": {
                return Optional.ofNullable(clazz.cast(this.quoteCharacter()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CSVInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileHeaderInfo;
        private String comments;
        private String quoteEscapeCharacter;
        private String recordDelimiter;
        private String fieldDelimiter;
        private String quoteCharacter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVInput model) {
            this.fileHeaderInfo(model.fileHeaderInfo);
            this.comments(model.comments);
            this.quoteEscapeCharacter(model.quoteEscapeCharacter);
            this.recordDelimiter(model.recordDelimiter);
            this.fieldDelimiter(model.fieldDelimiter);
            this.quoteCharacter(model.quoteCharacter);
        }

        public final String getFileHeaderInfo() {
            return this.fileHeaderInfo;
        }

        @Override
        public final Builder fileHeaderInfo(String fileHeaderInfo) {
            this.fileHeaderInfo = fileHeaderInfo;
            return this;
        }

        @Override
        public final Builder fileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
            this.fileHeaderInfo(fileHeaderInfo.toString());
            return this;
        }

        public final void setFileHeaderInfo(String fileHeaderInfo) {
            this.fileHeaderInfo = fileHeaderInfo;
        }

        public final String getComments() {
            return this.comments;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public final void setComments(String comments) {
            this.comments = comments;
        }

        public final String getQuoteEscapeCharacter() {
            return this.quoteEscapeCharacter;
        }

        @Override
        public final Builder quoteEscapeCharacter(String quoteEscapeCharacter) {
            this.quoteEscapeCharacter = quoteEscapeCharacter;
            return this;
        }

        public final void setQuoteEscapeCharacter(String quoteEscapeCharacter) {
            this.quoteEscapeCharacter = quoteEscapeCharacter;
        }

        public final String getRecordDelimiter() {
            return this.recordDelimiter;
        }

        @Override
        public final Builder recordDelimiter(String recordDelimiter) {
            this.recordDelimiter = recordDelimiter;
            return this;
        }

        public final void setRecordDelimiter(String recordDelimiter) {
            this.recordDelimiter = recordDelimiter;
        }

        public final String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        public final String getQuoteCharacter() {
            return this.quoteCharacter;
        }

        @Override
        public final Builder quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public final void setQuoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
        }

        public CSVInput build() {
            return new CSVInput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CSVInput> {
        public Builder fileHeaderInfo(String var1);

        public Builder fileHeaderInfo(FileHeaderInfo var1);

        public Builder comments(String var1);

        public Builder quoteEscapeCharacter(String var1);

        public Builder recordDelimiter(String var1);

        public Builder fieldDelimiter(String var1);

        public Builder quoteCharacter(String var1);
    }
}

