/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.VaultNotificationConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VaultNotificationConfigMarshaller {
    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopic").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Events").isBinary(false).build();
    private static final VaultNotificationConfigMarshaller INSTANCE = new VaultNotificationConfigMarshaller();

    private VaultNotificationConfigMarshaller() {
    }

    public static VaultNotificationConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VaultNotificationConfig vaultNotificationConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vaultNotificationConfig, (String)"vaultNotificationConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vaultNotificationConfig.snsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall(vaultNotificationConfig.events(), EVENTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

