/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RemoveTagsFromVaultRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeys").isBinary(false).build();
    private static final RemoveTagsFromVaultRequestModelMarshaller INSTANCE = new RemoveTagsFromVaultRequestModelMarshaller();

    private RemoveTagsFromVaultRequestModelMarshaller() {
    }

    public static RemoveTagsFromVaultRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemoveTagsFromVaultRequest removeTagsFromVaultRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)removeTagsFromVaultRequest), (String)"removeTagsFromVaultRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)removeTagsFromVaultRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)removeTagsFromVaultRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(removeTagsFromVaultRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

