/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedCapacityDescriptionMarshaller {
    private static final MarshallingInfo<String> CAPACITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityId").isBinary(false).build();
    private static final MarshallingInfo<String> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").isBinary(false).build();
    private static final MarshallingInfo<String> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").isBinary(false).build();
    private static final ProvisionedCapacityDescriptionMarshaller INSTANCE = new ProvisionedCapacityDescriptionMarshaller();

    private ProvisionedCapacityDescriptionMarshaller() {
    }

    public static ProvisionedCapacityDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedCapacityDescription provisionedCapacityDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedCapacityDescription, (String)"provisionedCapacityDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.capacityId(), CAPACITYID_BINDING);
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.expirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

