/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.PartListElement;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PartListElementMarshaller {
    private static final MarshallingInfo<String> RANGEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangeInBytes").isBinary(false).build();
    private static final MarshallingInfo<String> SHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SHA256TreeHash").isBinary(false).build();
    private static final PartListElementMarshaller INSTANCE = new PartListElementMarshaller();

    private PartListElementMarshaller() {
    }

    public static PartListElementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PartListElement partListElement, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)partListElement, (String)"partListElement");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)partListElement.rangeInBytes(), RANGEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)partListElement.sha256TreeHash(), SHA256TREEHASH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

