/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListTagsForVaultRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final ListTagsForVaultRequestModelMarshaller INSTANCE = new ListTagsForVaultRequestModelMarshaller();

    private ListTagsForVaultRequestModelMarshaller() {
    }

    public static ListTagsForVaultRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListTagsForVaultRequest listTagsForVaultRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listTagsForVaultRequest), (String)"listTagsForVaultRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listTagsForVaultRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)listTagsForVaultRequest.vaultName(), VAULTNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

