/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.transform.PartListElementUnmarshaller;

public class ListPartsResponseUnmarshaller
implements Unmarshaller<ListPartsResponse, JsonUnmarshallerContext> {
    private static final ListPartsResponseUnmarshaller INSTANCE = new ListPartsResponseUnmarshaller();

    public ListPartsResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        ListPartsResponse.Builder listPartsResponseBuilder = ListPartsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return (ListPartsResponse)((Object)listPartsResponseBuilder.build());
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MultipartUploadId", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.multipartUploadId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VaultARN", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.vaultARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ArchiveDescription", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.archiveDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PartSizeInBytes", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.partSizeInBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.creationDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parts", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.parts(new ListUnmarshaller((Unmarshaller)PartListElementUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Marker", targetDepth)) {
                    context.nextToken();
                    listPartsResponseBuilder.marker((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ListPartsResponse)((Object)listPartsResponseBuilder.build());
    }

    public static ListPartsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

