/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AbortMultipartUploadRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").isBinary(false).build();
    private static final AbortMultipartUploadRequestModelMarshaller INSTANCE = new AbortMultipartUploadRequestModelMarshaller();

    private AbortMultipartUploadRequestModelMarshaller() {
    }

    public static AbortMultipartUploadRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AbortMultipartUploadRequest abortMultipartUploadRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)abortMultipartUploadRequest), (String)"abortMultipartUploadRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)abortMultipartUploadRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)abortMultipartUploadRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)abortMultipartUploadRequest.uploadId(), UPLOADID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

