/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.PartListElement;

public class ListPartsPublisher
implements SdkPublisher<ListPartsResponse> {
    private final GlacierAsyncClient client;
    private final ListPartsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPartsPublisher(GlacierAsyncClient client, ListPartsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPartsPublisher(GlacierAsyncClient client, ListPartsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPartsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPartsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PartListElement> parts() {
        Function<ListPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPartsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListPartsPublisher resume(ListPartsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPartsPublisher(this.client, (ListPartsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPartsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPartsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPartsResponseFetcher
    implements AsyncPageFetcher<ListPartsResponse> {
        private ListPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<ListPartsResponse> nextPage(ListPartsResponse previousPage) {
            if (previousPage == null) {
                return ListPartsPublisher.this.client.listParts(ListPartsPublisher.this.firstRequest);
            }
            return ListPartsPublisher.this.client.listParts((ListPartsRequest)((Object)ListPartsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

