/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetDataRetrievalPolicyRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, SetDataRetrievalPolicyRequest> {
    private final String accountId;
    private final DataRetrievalPolicy policy;

    private SetDataRetrievalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.policy = builder.policy;
    }

    public String accountId() {
        return this.accountId;
    }

    public DataRetrievalPolicy policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDataRetrievalPolicyRequest)) {
            return false;
        }
        SetDataRetrievalPolicyRequest other = (SetDataRetrievalPolicyRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.policy(), other.policy());
    }

    public String toString() {
        return ToString.builder((String)"SetDataRetrievalPolicyRequest").add("AccountId", (Object)this.accountId()).add("Policy", (Object)this.policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private DataRetrievalPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDataRetrievalPolicyRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.policy(model.policy);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final DataRetrievalPolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(DataRetrievalPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(DataRetrievalPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDataRetrievalPolicyRequest build() {
            return new SetDataRetrievalPolicyRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, SetDataRetrievalPolicyRequest> {
        public Builder accountId(String var1);

        public Builder policy(DataRetrievalPolicy var1);

        default public Builder policy(Consumer<DataRetrievalPolicy.Builder> policy) {
            return this.policy((DataRetrievalPolicy)((DataRetrievalPolicy.Builder)DataRetrievalPolicy.builder().applyMutation(policy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

