/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseProvisionedCapacityRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, PurchaseProvisionedCapacityRequest> {
    private final String accountId;

    private PurchaseProvisionedCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
    }

    public String accountId() {
        return this.accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseProvisionedCapacityRequest)) {
            return false;
        }
        PurchaseProvisionedCapacityRequest other = (PurchaseProvisionedCapacityRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseProvisionedCapacityRequest").add("AccountId", (Object)this.accountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseProvisionedCapacityRequest model) {
            super(model);
            this.accountId(model.accountId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseProvisionedCapacityRequest build() {
            return new PurchaseProvisionedCapacityRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, PurchaseProvisionedCapacityRequest> {
        public Builder accountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

