/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private final String accountId;
    private final String vaultName;
    private final String limit;
    private final String marker;
    private final String statuscode;
    private final String completed;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.statuscode = builder.statuscode;
        this.completed = builder.completed;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    public String statuscode() {
        return this.statuscode;
    }

    public String completed() {
        return this.completed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.statuscode());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.statuscode(), other.statuscode()) && Objects.equals(this.completed(), other.completed());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).add("Statuscode", (Object)this.statuscode()).add("Completed", (Object)this.completed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "statuscode": {
                return Optional.ofNullable(clazz.cast(this.statuscode()));
            }
            case "completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String limit;
        private String marker;
        private String statuscode;
        private String completed;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.limit(model.limit);
            this.marker(model.marker);
            this.statuscode(model.statuscode);
            this.completed(model.completed);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getStatuscode() {
            return this.statuscode;
        }

        @Override
        public final Builder statuscode(String statuscode) {
            this.statuscode = statuscode;
            return this;
        }

        public final void setStatuscode(String statuscode) {
            this.statuscode = statuscode;
        }

        public final String getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(String completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(String completed) {
            this.completed = completed;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder limit(String var1);

        public Builder marker(String var1);

        public Builder statuscode(String var1);

        public Builder completed(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

