/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput;
import software.amazon.awssdk.services.glacier.transform.JobParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, JobParameters> {
    private final String format;
    private final String type;
    private final String archiveId;
    private final String description;
    private final String snsTopic;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobInput inventoryRetrievalParameters;

    private JobParameters(BuilderImpl builder) {
        this.format = builder.format;
        this.type = builder.type;
        this.archiveId = builder.archiveId;
        this.description = builder.description;
        this.snsTopic = builder.snsTopic;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
    }

    public String format() {
        return this.format;
    }

    public String type() {
        return this.type;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public String description() {
        return this.description;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public String tier() {
        return this.tier;
    }

    public InventoryRetrievalJobInput inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryRetrievalParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        JobParameters other = (JobParameters)obj;
        return Objects.equals(this.format(), other.format()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.inventoryRetrievalParameters(), other.inventoryRetrievalParameters());
    }

    public String toString() {
        return ToString.builder((String)"JobParameters").add("Format", (Object)this.format()).add("Type", (Object)this.type()).add("ArchiveId", (Object)this.archiveId()).add("Description", (Object)this.description()).add("SNSTopic", (Object)this.snsTopic()).add("RetrievalByteRange", (Object)this.retrievalByteRange()).add("Tier", (Object)this.tier()).add("InventoryRetrievalParameters", (Object)this.inventoryRetrievalParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SNSTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "RetrievalByteRange": {
                return Optional.ofNullable(clazz.cast(this.retrievalByteRange()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "InventoryRetrievalParameters": {
                return Optional.ofNullable(clazz.cast(this.inventoryRetrievalParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String type;
        private String archiveId;
        private String description;
        private String snsTopic;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobInput inventoryRetrievalParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(JobParameters model) {
            this.format(model.format);
            this.type(model.type);
            this.archiveId(model.archiveId);
            this.description(model.description);
            this.snsTopic(model.snsTopic);
            this.retrievalByteRange(model.retrievalByteRange);
            this.tier(model.tier);
            this.inventoryRetrievalParameters(model.inventoryRetrievalParameters);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobInput.Builder getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters != null ? this.inventoryRetrievalParameters.toBuilder() : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobInput.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build() : null;
        }

        public JobParameters build() {
            return new JobParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobParameters> {
        public Builder format(String var1);

        public Builder type(String var1);

        public Builder archiveId(String var1);

        public Builder description(String var1);

        public Builder snsTopic(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobInput var1);

        default public Builder inventoryRetrievalParameters(Consumer<InventoryRetrievalJobInput.Builder> inventoryRetrievalParameters) {
            return this.inventoryRetrievalParameters((InventoryRetrievalJobInput)((InventoryRetrievalJobInput.Builder)InventoryRetrievalJobInput.builder().applyMutation(inventoryRetrievalParameters)).build());
        }
    }
}

