/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.model.VaultLockPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateVaultLockRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, InitiateVaultLockRequest> {
    private final String accountId;
    private final String vaultName;
    private final VaultLockPolicy policy;

    private InitiateVaultLockRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.policy = builder.policy;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public VaultLockPolicy policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateVaultLockRequest)) {
            return false;
        }
        InitiateVaultLockRequest other = (InitiateVaultLockRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.policy(), other.policy());
    }

    public String toString() {
        return ToString.builder((String)"InitiateVaultLockRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("Policy", (Object)this.policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private VaultLockPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateVaultLockRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.policy(model.policy);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final VaultLockPolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(VaultLockPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(VaultLockPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateVaultLockRequest build() {
            return new InitiateVaultLockRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, InitiateVaultLockRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder policy(VaultLockPolicy var1);

        default public Builder policy(Consumer<VaultLockPolicy.Builder> policy) {
            return this.policy((VaultLockPolicy)((VaultLockPolicy.Builder)VaultLockPolicy.builder().applyMutation(policy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

