/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.JobParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobParametersMarshaller {
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHIVEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopic").isBinary(false).build();
    private static final MarshallingInfo<String> RETRIEVALBYTERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetrievalByteRange").isBinary(false).build();
    private static final MarshallingInfo<String> TIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INVENTORYRETRIEVALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InventoryRetrievalParameters").isBinary(false).build();
    private static final JobParametersMarshaller INSTANCE = new JobParametersMarshaller();

    private JobParametersMarshaller() {
    }

    public static JobParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobParameters jobParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobParameters, (String)"jobParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobParameters.format(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.archiveId(), ARCHIVEID_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.snsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.retrievalByteRange(), RETRIEVALBYTERANGE_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.tier(), TIER_BINDING);
            protocolMarshaller.marshall((Object)jobParameters.inventoryRetrievalParameters(), INVENTORYRETRIEVALPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

