/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.transform.InitiateVaultLockRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InitiateVaultLockRequestMarshaller
implements Marshaller<Request<InitiateVaultLockRequest>, InitiateVaultLockRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/{accountId}/vaults/{vaultName}/lock-policy").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(true).hasPayloadMembers(true).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public InitiateVaultLockRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InitiateVaultLockRequest> marshall(InitiateVaultLockRequest initiateVaultLockRequest) {
        Validate.paramNotNull((Object)((Object)initiateVaultLockRequest), (String)"initiateVaultLockRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)initiateVaultLockRequest);
            protocolMarshaller.startMarshalling();
            InitiateVaultLockRequestModelMarshaller.getInstance().marshall(initiateVaultLockRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

