/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InitiateMultipartUploadRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-description").isBinary(false).build();
    private static final MarshallingInfo<String> PARTSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-part-size").isBinary(false).build();
    private static final InitiateMultipartUploadRequestModelMarshaller INSTANCE = new InitiateMultipartUploadRequestModelMarshaller();

    private InitiateMultipartUploadRequestModelMarshaller() {
    }

    public static InitiateMultipartUploadRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InitiateMultipartUploadRequest initiateMultipartUploadRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)initiateMultipartUploadRequest), (String)"initiateMultipartUploadRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.archiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.partSize(), PARTSIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

