/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompleteVaultLockRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> LOCKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("lockId").isBinary(false).build();
    private static final CompleteVaultLockRequestModelMarshaller INSTANCE = new CompleteVaultLockRequestModelMarshaller();

    private CompleteVaultLockRequestModelMarshaller() {
    }

    public static CompleteVaultLockRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompleteVaultLockRequest completeVaultLockRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)completeVaultLockRequest), (String)"completeVaultLockRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)completeVaultLockRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)completeVaultLockRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)completeVaultLockRequest.lockId(), LOCKID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

