/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AbortVaultLockRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final AbortVaultLockRequestModelMarshaller INSTANCE = new AbortVaultLockRequestModelMarshaller();

    private AbortVaultLockRequestModelMarshaller() {
    }

    public static AbortVaultLockRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AbortVaultLockRequest abortVaultLockRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)abortVaultLockRequest), (String)"abortVaultLockRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)abortVaultLockRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)abortVaultLockRequest.vaultName(), VAULTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

