/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class ListPartsRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").build();
    private static final MarshallingInfo<String> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").build();
    private static final ListPartsRequestModelMarshaller instance = new ListPartsRequestModelMarshaller();

    public static ListPartsRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(ListPartsRequest listPartsRequest, ProtocolMarshaller protocolMarshaller) {
        if (listPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)listPartsRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)listPartsRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)listPartsRequest.uploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)listPartsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)listPartsRequest.limit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

