/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;

@SdkInternalApi
public class GlacierJobDescriptionMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").build();
    private static final MarshallingInfo<String> JOBDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobDescription").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> ARCHIVEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveId").build();
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<Boolean> COMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Completed").build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<Long> ARCHIVESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveSizeInBytes").build();
    private static final MarshallingInfo<Long> INVENTORYSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InventorySizeInBytes").build();
    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopic").build();
    private static final MarshallingInfo<String> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").build();
    private static final MarshallingInfo<String> SHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SHA256TreeHash").build();
    private static final MarshallingInfo<String> ARCHIVESHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveSHA256TreeHash").build();
    private static final MarshallingInfo<String> RETRIEVALBYTERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetrievalByteRange").build();
    private static final MarshallingInfo<String> TIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tier").build();
    private static final MarshallingInfo<StructuredPojo> INVENTORYRETRIEVALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InventoryRetrievalParameters").build();
    private static final GlacierJobDescriptionMarshaller instance = new GlacierJobDescriptionMarshaller();

    public static GlacierJobDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(GlacierJobDescription glacierJobDescription, ProtocolMarshaller protocolMarshaller) {
        if (glacierJobDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)glacierJobDescription.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.jobDescription(), JOBDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveId(), ARCHIVEID_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.vaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.completed(), COMPLETED_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveSizeInBytes(), ARCHIVESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.inventorySizeInBytes(), INVENTORYSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.snsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.completionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.sha256TreeHash(), SHA256TREEHASH_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveSHA256TreeHash(), ARCHIVESHA256TREEHASH_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.retrievalByteRange(), RETRIEVALBYTERANGE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.tier(), TIER_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.inventoryRetrievalParameters(), INVENTORYRETRIEVALPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

