/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.glacier.model.VaultAccessPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetVaultAccessPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetVaultAccessPolicyRequest> {
    private final String accountId;
    private final String vaultName;
    private final VaultAccessPolicy policy;

    private SetVaultAccessPolicyRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.policy = builder.policy;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public VaultAccessPolicy policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.policy() == null ? 0 : this.policy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVaultAccessPolicyRequest)) {
            return false;
        }
        SetVaultAccessPolicyRequest other = (SetVaultAccessPolicyRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        return other.policy() == null || other.policy().equals(this.policy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private VaultAccessPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(SetVaultAccessPolicyRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setPolicy(model.policy);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final VaultAccessPolicy getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(VaultAccessPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(VaultAccessPolicy policy) {
            this.policy = policy;
        }

        public SetVaultAccessPolicyRequest build() {
            return new SetVaultAccessPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetVaultAccessPolicyRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder policy(VaultAccessPolicy var1);
    }
}

