/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.VaultListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVaultsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListVaultsResponse> {
    private final List<DescribeVaultOutput> vaultList;
    private final String marker;

    private ListVaultsResponse(BuilderImpl builder) {
        this.vaultList = builder.vaultList;
        this.marker = builder.marker;
    }

    public List<DescribeVaultOutput> vaultList() {
        return this.vaultList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vaultList() == null ? 0 : this.vaultList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResponse)) {
            return false;
        }
        ListVaultsResponse other = (ListVaultsResponse)((Object)obj);
        if (other.vaultList() == null ^ this.vaultList() == null) {
            return false;
        }
        if (other.vaultList() != null && !other.vaultList().equals(this.vaultList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.vaultList() != null) {
            sb.append("VaultList: ").append(this.vaultList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DescribeVaultOutput> vaultList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsResponse model) {
            this.setVaultList(model.vaultList);
            this.setMarker(model.marker);
        }

        public final Collection<DescribeVaultOutput> getVaultList() {
            return this.vaultList;
        }

        @Override
        public final Builder vaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(DescribeVaultOutput ... vaultList) {
            if (this.vaultList == null) {
                this.vaultList = new ArrayList<DescribeVaultOutput>(vaultList.length);
            }
            for (DescribeVaultOutput e : vaultList) {
                this.vaultList.add(e);
            }
            return this;
        }

        public final void setVaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
        }

        @SafeVarargs
        public final void setVaultList(DescribeVaultOutput ... vaultList) {
            if (this.vaultList == null) {
                this.vaultList = new ArrayList<DescribeVaultOutput>(vaultList.length);
            }
            for (DescribeVaultOutput e : vaultList) {
                this.vaultList.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListVaultsResponse build() {
            return new ListVaultsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVaultsResponse> {
        public Builder vaultList(Collection<DescribeVaultOutput> var1);

        public Builder vaultList(DescribeVaultOutput ... var1);

        public Builder marker(String var1);
    }
}

