/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetJobOutputResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetJobOutputResponse> {
    private final String checksum;
    private final Integer status;
    private final String contentRange;
    private final String acceptRanges;
    private final String contentType;
    private final String archiveDescription;

    private GetJobOutputResponse(BuilderImpl builder) {
        this.checksum = builder.checksum;
        this.status = builder.status;
        this.contentRange = builder.contentRange;
        this.acceptRanges = builder.acceptRanges;
        this.contentType = builder.contentType;
        this.archiveDescription = builder.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Integer status() {
        return this.status;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public String contentType() {
        return this.contentType;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.contentRange() == null ? 0 : this.contentRange().hashCode());
        hashCode = 31 * hashCode + (this.acceptRanges() == null ? 0 : this.acceptRanges().hashCode());
        hashCode = 31 * hashCode + (this.contentType() == null ? 0 : this.contentType().hashCode());
        hashCode = 31 * hashCode + (this.archiveDescription() == null ? 0 : this.archiveDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobOutputResponse)) {
            return false;
        }
        GetJobOutputResponse other = (GetJobOutputResponse)((Object)obj);
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.contentRange() == null ^ this.contentRange() == null) {
            return false;
        }
        if (other.contentRange() != null && !other.contentRange().equals(this.contentRange())) {
            return false;
        }
        if (other.acceptRanges() == null ^ this.acceptRanges() == null) {
            return false;
        }
        if (other.acceptRanges() != null && !other.acceptRanges().equals(this.acceptRanges())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.archiveDescription() == null ^ this.archiveDescription() == null) {
            return false;
        }
        return other.archiveDescription() == null || other.archiveDescription().equals(this.archiveDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.contentRange() != null) {
            sb.append("ContentRange: ").append(this.contentRange()).append(",");
        }
        if (this.acceptRanges() != null) {
            sb.append("AcceptRanges: ").append(this.acceptRanges()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String checksum;
        private Integer status;
        private String contentRange;
        private String acceptRanges;
        private String contentType;
        private String archiveDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobOutputResponse model) {
            this.setChecksum(model.checksum);
            this.setStatus(model.status);
            this.setContentRange(model.contentRange);
            this.setAcceptRanges(model.acceptRanges);
            this.setContentType(model.contentType);
            this.setArchiveDescription(model.archiveDescription);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public final String getAcceptRanges() {
            return this.acceptRanges;
        }

        @Override
        public final Builder acceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        public final void setAcceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public GetJobOutputResponse build() {
            return new GetJobOutputResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetJobOutputResponse> {
        public Builder checksum(String var1);

        public Builder status(Integer var1);

        public Builder contentRange(String var1);

        public Builder acceptRanges(String var1);

        public Builder contentType(String var1);

        public Builder archiveDescription(String var1);
    }
}

