/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteResponseNoticeCode {
    MAIN_LANGUAGE_NOT_FOUND("MainLanguageNotFound"),
    OTHER("Other"),
    TRAVEL_TIME_EXCEEDS_DRIVER_WORK_HOURS("TravelTimeExceedsDriverWorkHours"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteResponseNoticeCode> VALUE_MAP;
    private final String value;

    private RouteResponseNoticeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteResponseNoticeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteResponseNoticeCode> knownValues() {
        EnumSet<RouteResponseNoticeCode> knownValues = EnumSet.allOf(RouteResponseNoticeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteResponseNoticeCode.class, RouteResponseNoticeCode::toString);
    }
}

