/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteEmissionType;
import software.amazon.awssdk.services.georoutes.model.RouteTollVehicleCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTollOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTollOptions> {
    private static final SdkField<Boolean> ALL_TRANSPONDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllTransponders").getter(RouteTollOptions.getter(RouteTollOptions::allTransponders)).setter(RouteTollOptions.setter(Builder::allTransponders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllTransponders").build()}).build();
    private static final SdkField<Boolean> ALL_VIGNETTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllVignettes").getter(RouteTollOptions.getter(RouteTollOptions::allVignettes)).setter(RouteTollOptions.setter(Builder::allVignettes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllVignettes").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Currency").getter(RouteTollOptions.getter(RouteTollOptions::currency)).setter(RouteTollOptions.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()}).build();
    private static final SdkField<RouteEmissionType> EMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmissionType").getter(RouteTollOptions.getter(RouteTollOptions::emissionType)).setter(RouteTollOptions.setter(Builder::emissionType)).constructor(RouteEmissionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmissionType").build()}).build();
    private static final SdkField<String> VEHICLE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VehicleCategory").getter(RouteTollOptions.getter(RouteTollOptions::vehicleCategoryAsString)).setter(RouteTollOptions.setter(Builder::vehicleCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VehicleCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_TRANSPONDERS_FIELD, ALL_VIGNETTES_FIELD, CURRENCY_FIELD, EMISSION_TYPE_FIELD, VEHICLE_CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteTollOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean allTransponders;
    private final Boolean allVignettes;
    private final String currency;
    private final RouteEmissionType emissionType;
    private final String vehicleCategory;

    private RouteTollOptions(BuilderImpl builder) {
        this.allTransponders = builder.allTransponders;
        this.allVignettes = builder.allVignettes;
        this.currency = builder.currency;
        this.emissionType = builder.emissionType;
        this.vehicleCategory = builder.vehicleCategory;
    }

    public final Boolean allTransponders() {
        return this.allTransponders;
    }

    public final Boolean allVignettes() {
        return this.allVignettes;
    }

    public final String currency() {
        return this.currency;
    }

    public final RouteEmissionType emissionType() {
        return this.emissionType;
    }

    public final RouteTollVehicleCategory vehicleCategory() {
        return RouteTollVehicleCategory.fromValue(this.vehicleCategory);
    }

    public final String vehicleCategoryAsString() {
        return this.vehicleCategory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allTransponders());
        hashCode = 31 * hashCode + Objects.hashCode(this.allVignettes());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        hashCode = 31 * hashCode + Objects.hashCode(this.emissionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleCategoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollOptions)) {
            return false;
        }
        RouteTollOptions other = (RouteTollOptions)obj;
        return Objects.equals(this.allTransponders(), other.allTransponders()) && Objects.equals(this.allVignettes(), other.allVignettes()) && Objects.equals(this.currency(), other.currency()) && Objects.equals(this.emissionType(), other.emissionType()) && Objects.equals(this.vehicleCategoryAsString(), other.vehicleCategoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteTollOptions").add("AllTransponders", (Object)this.allTransponders()).add("AllVignettes", (Object)this.allVignettes()).add("Currency", (Object)this.currency()).add("EmissionType", (Object)this.emissionType()).add("VehicleCategory", (Object)this.vehicleCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllTransponders": {
                return Optional.ofNullable(clazz.cast(this.allTransponders()));
            }
            case "AllVignettes": {
                return Optional.ofNullable(clazz.cast(this.allVignettes()));
            }
            case "Currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
            case "EmissionType": {
                return Optional.ofNullable(clazz.cast(this.emissionType()));
            }
            case "VehicleCategory": {
                return Optional.ofNullable(clazz.cast(this.vehicleCategoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllTransponders", ALL_TRANSPONDERS_FIELD);
        map.put("AllVignettes", ALL_VIGNETTES_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        map.put("EmissionType", EMISSION_TYPE_FIELD);
        map.put("VehicleCategory", VEHICLE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollOptions, T> g) {
        return obj -> g.apply((RouteTollOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allTransponders;
        private Boolean allVignettes;
        private String currency;
        private RouteEmissionType emissionType;
        private String vehicleCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollOptions model) {
            this.allTransponders(model.allTransponders);
            this.allVignettes(model.allVignettes);
            this.currency(model.currency);
            this.emissionType(model.emissionType);
            this.vehicleCategory(model.vehicleCategory);
        }

        public final Boolean getAllTransponders() {
            return this.allTransponders;
        }

        public final void setAllTransponders(Boolean allTransponders) {
            this.allTransponders = allTransponders;
        }

        @Override
        public final Builder allTransponders(Boolean allTransponders) {
            this.allTransponders = allTransponders;
            return this;
        }

        public final Boolean getAllVignettes() {
            return this.allVignettes;
        }

        public final void setAllVignettes(Boolean allVignettes) {
            this.allVignettes = allVignettes;
        }

        @Override
        public final Builder allVignettes(Boolean allVignettes) {
            this.allVignettes = allVignettes;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final RouteEmissionType.Builder getEmissionType() {
            return this.emissionType != null ? this.emissionType.toBuilder() : null;
        }

        public final void setEmissionType(RouteEmissionType.BuilderImpl emissionType) {
            this.emissionType = emissionType != null ? emissionType.build() : null;
        }

        @Override
        public final Builder emissionType(RouteEmissionType emissionType) {
            this.emissionType = emissionType;
            return this;
        }

        public final String getVehicleCategory() {
            return this.vehicleCategory;
        }

        public final void setVehicleCategory(String vehicleCategory) {
            this.vehicleCategory = vehicleCategory;
        }

        @Override
        public final Builder vehicleCategory(String vehicleCategory) {
            this.vehicleCategory = vehicleCategory;
            return this;
        }

        @Override
        public final Builder vehicleCategory(RouteTollVehicleCategory vehicleCategory) {
            this.vehicleCategory(vehicleCategory == null ? null : vehicleCategory.toString());
            return this;
        }

        public RouteTollOptions build() {
            return new RouteTollOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTollOptions> {
        public Builder allTransponders(Boolean var1);

        public Builder allVignettes(Boolean var1);

        public Builder currency(String var1);

        public Builder emissionType(RouteEmissionType var1);

        default public Builder emissionType(Consumer<RouteEmissionType.Builder> emissionType) {
            return this.emissionType((RouteEmissionType)((RouteEmissionType.Builder)RouteEmissionType.builder().applyMutation(emissionType)).build());
        }

        public Builder vehicleCategory(String var1);

        public Builder vehicleCategory(RouteTollVehicleCategory var1);
    }
}

