/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteDirection {
    EAST("East"),
    NORTH("North"),
    SOUTH("South"),
    WEST("West"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteDirection> VALUE_MAP;
    private final String value;

    private RouteDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteDirection> knownValues() {
        EnumSet<RouteDirection> knownValues = EnumSet.allOf(RouteDirection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteDirection.class, RouteDirection::toString);
    }
}

