/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WaypointOptimizationConstraint {
    ACCESS_HOURS("AccessHours"),
    APPOINTMENT_TIME("AppointmentTime"),
    BEFORE("Before"),
    HEADING("Heading"),
    SERVICE_DURATION("ServiceDuration"),
    SIDE_OF_STREET("SideOfStreet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WaypointOptimizationConstraint> VALUE_MAP;
    private final String value;

    private WaypointOptimizationConstraint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WaypointOptimizationConstraint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WaypointOptimizationConstraint> knownValues() {
        EnumSet<WaypointOptimizationConstraint> knownValues = EnumSet.allOf(WaypointOptimizationConstraint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WaypointOptimizationConstraint.class, WaypointOptimizationConstraint::toString);
    }
}

