/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IsolineTruckType {
    LIGHT_TRUCK("LightTruck"),
    STRAIGHT_TRUCK("StraightTruck"),
    TRACTOR("Tractor"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IsolineTruckType> VALUE_MAP;
    private final String value;

    private IsolineTruckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IsolineTruckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IsolineTruckType> knownValues() {
        EnumSet<IsolineTruckType> knownValues = EnumSet.allOf(IsolineTruckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IsolineTruckType.class, IsolineTruckType::toString);
    }
}

