/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.Isoline;
import software.amazon.awssdk.services.georoutes.model.IsolineListCopier;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateIsolinesResponse
extends GeoRoutesResponse
implements ToCopyableBuilder<Builder, CalculateIsolinesResponse> {
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArrivalTime").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::arrivalTime)).setter(CalculateIsolinesResponse.setter(Builder::arrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::departureTime)).setter(CalculateIsolinesResponse.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<String> ISOLINE_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsolineGeometryFormat").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::isolineGeometryFormatAsString)).setter(CalculateIsolinesResponse.setter(Builder::isolineGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolineGeometryFormat").build()}).build();
    private static final SdkField<List<Isoline>> ISOLINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Isolines").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::isolines)).setter(CalculateIsolinesResponse.setter(Builder::isolines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isolines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Isoline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::pricingBucket)).setter(CalculateIsolinesResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<Double>> SNAPPED_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedDestination").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::snappedDestination)).setter(CalculateIsolinesResponse.setter(Builder::snappedDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDestination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> SNAPPED_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedOrigin").getter(CalculateIsolinesResponse.getter(CalculateIsolinesResponse::snappedOrigin)).setter(CalculateIsolinesResponse.setter(Builder::snappedOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedOrigin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_TIME_FIELD, DEPARTURE_TIME_FIELD, ISOLINE_GEOMETRY_FORMAT_FIELD, ISOLINES_FIELD, PRICING_BUCKET_FIELD, SNAPPED_DESTINATION_FIELD, SNAPPED_ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateIsolinesResponse.memberNameToFieldInitializer();
    private final String arrivalTime;
    private final String departureTime;
    private final String isolineGeometryFormat;
    private final List<Isoline> isolines;
    private final String pricingBucket;
    private final List<Double> snappedDestination;
    private final List<Double> snappedOrigin;

    private CalculateIsolinesResponse(BuilderImpl builder) {
        super(builder);
        this.arrivalTime = builder.arrivalTime;
        this.departureTime = builder.departureTime;
        this.isolineGeometryFormat = builder.isolineGeometryFormat;
        this.isolines = builder.isolines;
        this.pricingBucket = builder.pricingBucket;
        this.snappedDestination = builder.snappedDestination;
        this.snappedOrigin = builder.snappedOrigin;
    }

    public final String arrivalTime() {
        return this.arrivalTime;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final GeometryFormat isolineGeometryFormat() {
        return GeometryFormat.fromValue(this.isolineGeometryFormat);
    }

    public final String isolineGeometryFormatAsString() {
        return this.isolineGeometryFormat;
    }

    public final boolean hasIsolines() {
        return this.isolines != null && !(this.isolines instanceof SdkAutoConstructList);
    }

    public final List<Isoline> isolines() {
        return this.isolines;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasSnappedDestination() {
        return this.snappedDestination != null && !(this.snappedDestination instanceof SdkAutoConstructList);
    }

    public final List<Double> snappedDestination() {
        return this.snappedDestination;
    }

    public final boolean hasSnappedOrigin() {
        return this.snappedOrigin != null && !(this.snappedOrigin instanceof SdkAutoConstructList);
    }

    public final List<Double> snappedOrigin() {
        return this.snappedOrigin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isolineGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIsolines() ? this.isolines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedDestination() ? this.snappedDestination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedOrigin() ? this.snappedOrigin() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateIsolinesResponse)) {
            return false;
        }
        CalculateIsolinesResponse other = (CalculateIsolinesResponse)((Object)obj);
        return Objects.equals(this.arrivalTime(), other.arrivalTime()) && Objects.equals(this.departureTime(), other.departureTime()) && Objects.equals(this.isolineGeometryFormatAsString(), other.isolineGeometryFormatAsString()) && this.hasIsolines() == other.hasIsolines() && Objects.equals(this.isolines(), other.isolines()) && Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasSnappedDestination() == other.hasSnappedDestination() && Objects.equals(this.snappedDestination(), other.snappedDestination()) && this.hasSnappedOrigin() == other.hasSnappedOrigin() && Objects.equals(this.snappedOrigin(), other.snappedOrigin());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateIsolinesResponse").add("ArrivalTime", (Object)this.arrivalTime()).add("DepartureTime", (Object)this.departureTime()).add("IsolineGeometryFormat", (Object)this.isolineGeometryFormatAsString()).add("Isolines", this.hasIsolines() ? this.isolines() : null).add("PricingBucket", (Object)this.pricingBucket()).add("SnappedDestination", (Object)(this.snappedDestination() == null ? null : "*** Sensitive Data Redacted ***")).add("SnappedOrigin", (Object)(this.snappedOrigin() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.arrivalTime()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "IsolineGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.isolineGeometryFormatAsString()));
            }
            case "Isolines": {
                return Optional.ofNullable(clazz.cast(this.isolines()));
            }
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "SnappedDestination": {
                return Optional.ofNullable(clazz.cast(this.snappedDestination()));
            }
            case "SnappedOrigin": {
                return Optional.ofNullable(clazz.cast(this.snappedOrigin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("IsolineGeometryFormat", ISOLINE_GEOMETRY_FORMAT_FIELD);
        map.put("Isolines", ISOLINES_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("SnappedDestination", SNAPPED_DESTINATION_FIELD);
        map.put("SnappedOrigin", SNAPPED_ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateIsolinesResponse, T> g) {
        return obj -> g.apply((CalculateIsolinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesResponse.BuilderImpl
    implements Builder {
        private String arrivalTime;
        private String departureTime;
        private String isolineGeometryFormat;
        private List<Isoline> isolines = DefaultSdkAutoConstructList.getInstance();
        private String pricingBucket;
        private List<Double> snappedDestination = DefaultSdkAutoConstructList.getInstance();
        private List<Double> snappedOrigin = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateIsolinesResponse model) {
            super(model);
            this.arrivalTime(model.arrivalTime);
            this.departureTime(model.departureTime);
            this.isolineGeometryFormat(model.isolineGeometryFormat);
            this.isolines(model.isolines);
            this.pricingBucket(model.pricingBucket);
            this.snappedDestination(model.snappedDestination);
            this.snappedOrigin(model.snappedOrigin);
        }

        public final String getArrivalTime() {
            return this.arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final String getIsolineGeometryFormat() {
            return this.isolineGeometryFormat;
        }

        public final void setIsolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
        }

        @Override
        public final Builder isolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
            return this;
        }

        @Override
        public final Builder isolineGeometryFormat(GeometryFormat isolineGeometryFormat) {
            this.isolineGeometryFormat(isolineGeometryFormat == null ? null : isolineGeometryFormat.toString());
            return this;
        }

        public final List<Isoline.Builder> getIsolines() {
            List<Isoline.Builder> result = IsolineListCopier.copyToBuilder(this.isolines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIsolines(Collection<Isoline.BuilderImpl> isolines) {
            this.isolines = IsolineListCopier.copyFromBuilder(isolines);
        }

        @Override
        public final Builder isolines(Collection<Isoline> isolines) {
            this.isolines = IsolineListCopier.copy(isolines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isolines(Isoline ... isolines) {
            this.isolines(Arrays.asList(isolines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isolines(Consumer<Isoline.Builder> ... isolines) {
            this.isolines(Stream.of(isolines).map(c -> (Isoline)((Isoline.Builder)Isoline.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final Collection<Double> getSnappedDestination() {
            if (this.snappedDestination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snappedDestination;
        }

        public final void setSnappedDestination(Collection<Double> snappedDestination) {
            this.snappedDestination = PositionCopier.copy(snappedDestination);
        }

        @Override
        public final Builder snappedDestination(Collection<Double> snappedDestination) {
            this.snappedDestination = PositionCopier.copy(snappedDestination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDestination(Double ... snappedDestination) {
            this.snappedDestination(Arrays.asList(snappedDestination));
            return this;
        }

        public final Collection<Double> getSnappedOrigin() {
            if (this.snappedOrigin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snappedOrigin;
        }

        public final void setSnappedOrigin(Collection<Double> snappedOrigin) {
            this.snappedOrigin = PositionCopier.copy(snappedOrigin);
        }

        @Override
        public final Builder snappedOrigin(Collection<Double> snappedOrigin) {
            this.snappedOrigin = PositionCopier.copy(snappedOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedOrigin(Double ... snappedOrigin) {
            this.snappedOrigin(Arrays.asList(snappedOrigin));
            return this;
        }

        @Override
        public CalculateIsolinesResponse build() {
            return new CalculateIsolinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoRoutesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateIsolinesResponse> {
        public Builder arrivalTime(String var1);

        public Builder departureTime(String var1);

        public Builder isolineGeometryFormat(String var1);

        public Builder isolineGeometryFormat(GeometryFormat var1);

        public Builder isolines(Collection<Isoline> var1);

        public Builder isolines(Isoline ... var1);

        public Builder isolines(Consumer<Isoline.Builder> ... var1);

        public Builder pricingBucket(String var1);

        public Builder snappedDestination(Collection<Double> var1);

        public Builder snappedDestination(Double ... var1);

        public Builder snappedOrigin(Collection<Double> var1);

        public Builder snappedOrigin(Double ... var1);
    }
}

