/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSteeringDirection;
import software.amazon.awssdk.services.georoutes.model.RouteTurnIntensity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteRoundaboutEnterStepDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteRoundaboutEnterStepDetails> {
    private static final SdkField<List<LocalizedString>> INTERSECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Intersection").getter(RouteRoundaboutEnterStepDetails.getter(RouteRoundaboutEnterStepDetails::intersection)).setter(RouteRoundaboutEnterStepDetails.setter(Builder::intersection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STEERING_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SteeringDirection").getter(RouteRoundaboutEnterStepDetails.getter(RouteRoundaboutEnterStepDetails::steeringDirectionAsString)).setter(RouteRoundaboutEnterStepDetails.setter(Builder::steeringDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SteeringDirection").build()}).build();
    private static final SdkField<Double> TURN_ANGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TurnAngle").getter(RouteRoundaboutEnterStepDetails.getter(RouteRoundaboutEnterStepDetails::turnAngle)).setter(RouteRoundaboutEnterStepDetails.setter(Builder::turnAngle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnAngle").build()}).build();
    private static final SdkField<String> TURN_INTENSITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TurnIntensity").getter(RouteRoundaboutEnterStepDetails.getter(RouteRoundaboutEnterStepDetails::turnIntensityAsString)).setter(RouteRoundaboutEnterStepDetails.setter(Builder::turnIntensity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnIntensity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERSECTION_FIELD, STEERING_DIRECTION_FIELD, TURN_ANGLE_FIELD, TURN_INTENSITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteRoundaboutEnterStepDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LocalizedString> intersection;
    private final String steeringDirection;
    private final Double turnAngle;
    private final String turnIntensity;

    private RouteRoundaboutEnterStepDetails(BuilderImpl builder) {
        this.intersection = builder.intersection;
        this.steeringDirection = builder.steeringDirection;
        this.turnAngle = builder.turnAngle;
        this.turnIntensity = builder.turnIntensity;
    }

    public final boolean hasIntersection() {
        return this.intersection != null && !(this.intersection instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> intersection() {
        return this.intersection;
    }

    public final RouteSteeringDirection steeringDirection() {
        return RouteSteeringDirection.fromValue(this.steeringDirection);
    }

    public final String steeringDirectionAsString() {
        return this.steeringDirection;
    }

    public final Double turnAngle() {
        return this.turnAngle;
    }

    public final RouteTurnIntensity turnIntensity() {
        return RouteTurnIntensity.fromValue(this.turnIntensity);
    }

    public final String turnIntensityAsString() {
        return this.turnIntensity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntersection() ? this.intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.steeringDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.turnAngle());
        hashCode = 31 * hashCode + Objects.hashCode(this.turnIntensityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteRoundaboutEnterStepDetails)) {
            return false;
        }
        RouteRoundaboutEnterStepDetails other = (RouteRoundaboutEnterStepDetails)obj;
        return this.hasIntersection() == other.hasIntersection() && Objects.equals(this.intersection(), other.intersection()) && Objects.equals(this.steeringDirectionAsString(), other.steeringDirectionAsString()) && Objects.equals(this.turnAngle(), other.turnAngle()) && Objects.equals(this.turnIntensityAsString(), other.turnIntensityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteRoundaboutEnterStepDetails").add("Intersection", this.hasIntersection() ? this.intersection() : null).add("SteeringDirection", (Object)this.steeringDirectionAsString()).add("TurnAngle", (Object)this.turnAngle()).add("TurnIntensity", (Object)this.turnIntensityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Intersection": {
                return Optional.ofNullable(clazz.cast(this.intersection()));
            }
            case "SteeringDirection": {
                return Optional.ofNullable(clazz.cast(this.steeringDirectionAsString()));
            }
            case "TurnAngle": {
                return Optional.ofNullable(clazz.cast(this.turnAngle()));
            }
            case "TurnIntensity": {
                return Optional.ofNullable(clazz.cast(this.turnIntensityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Intersection", INTERSECTION_FIELD);
        map.put("SteeringDirection", STEERING_DIRECTION_FIELD);
        map.put("TurnAngle", TURN_ANGLE_FIELD);
        map.put("TurnIntensity", TURN_INTENSITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteRoundaboutEnterStepDetails, T> g) {
        return obj -> g.apply((RouteRoundaboutEnterStepDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LocalizedString> intersection = DefaultSdkAutoConstructList.getInstance();
        private String steeringDirection;
        private Double turnAngle;
        private String turnIntensity;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteRoundaboutEnterStepDetails model) {
            this.intersection(model.intersection);
            this.steeringDirection(model.steeringDirection);
            this.turnAngle(model.turnAngle);
            this.turnIntensity(model.turnIntensity);
        }

        public final List<LocalizedString.Builder> getIntersection() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<LocalizedString.BuilderImpl> intersection) {
            this.intersection = LocalizedStringListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<LocalizedString> intersection) {
            this.intersection = LocalizedStringListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(LocalizedString ... intersection) {
            this.intersection(Arrays.asList(intersection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Consumer<LocalizedString.Builder> ... intersection) {
            this.intersection(Stream.of(intersection).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSteeringDirection() {
            return this.steeringDirection;
        }

        public final void setSteeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
        }

        @Override
        public final Builder steeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
            return this;
        }

        @Override
        public final Builder steeringDirection(RouteSteeringDirection steeringDirection) {
            this.steeringDirection(steeringDirection == null ? null : steeringDirection.toString());
            return this;
        }

        public final Double getTurnAngle() {
            return this.turnAngle;
        }

        public final void setTurnAngle(Double turnAngle) {
            this.turnAngle = turnAngle;
        }

        @Override
        public final Builder turnAngle(Double turnAngle) {
            this.turnAngle = turnAngle;
            return this;
        }

        public final String getTurnIntensity() {
            return this.turnIntensity;
        }

        public final void setTurnIntensity(String turnIntensity) {
            this.turnIntensity = turnIntensity;
        }

        @Override
        public final Builder turnIntensity(String turnIntensity) {
            this.turnIntensity = turnIntensity;
            return this;
        }

        @Override
        public final Builder turnIntensity(RouteTurnIntensity turnIntensity) {
            this.turnIntensity(turnIntensity == null ? null : turnIntensity.toString());
            return this;
        }

        public RouteRoundaboutEnterStepDetails build() {
            return new RouteRoundaboutEnterStepDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteRoundaboutEnterStepDetails> {
        public Builder intersection(Collection<LocalizedString> var1);

        public Builder intersection(LocalizedString ... var1);

        public Builder intersection(Consumer<LocalizedString.Builder> ... var1);

        public Builder steeringDirection(String var1);

        public Builder steeringDirection(RouteSteeringDirection var1);

        public Builder turnAngle(Double var1);

        public Builder turnIntensity(String var1);

        public Builder turnIntensity(RouteTurnIntensity var1);
    }
}

