/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.RoadSnapTracePoint;
import software.amazon.awssdk.services.georoutes.model.RoadSnapTravelMode;
import software.amazon.awssdk.services.georoutes.model.RoadSnapTravelModeOptions;
import software.amazon.awssdk.services.georoutes.model.SnapToRoadsRequestTracePointsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapToRoadsRequest
extends GeoRoutesRequest
implements ToCopyableBuilder<Builder, SnapToRoadsRequest> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::key)).setter(SnapToRoadsRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<String> SNAPPED_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnappedGeometryFormat").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::snappedGeometryFormatAsString)).setter(SnapToRoadsRequest.setter(Builder::snappedGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometryFormat").build()}).build();
    private static final SdkField<Long> SNAP_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SnapRadius").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::snapRadius)).setter(SnapToRoadsRequest.setter(Builder::snapRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapRadius").build()}).build();
    private static final SdkField<List<RoadSnapTracePoint>> TRACE_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TracePoints").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::tracePoints)).setter(SnapToRoadsRequest.setter(Builder::tracePoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracePoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoadSnapTracePoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::travelModeAsString)).setter(SnapToRoadsRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<RoadSnapTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TravelModeOptions").getter(SnapToRoadsRequest.getter(SnapToRoadsRequest::travelModeOptions)).setter(SnapToRoadsRequest.setter(Builder::travelModeOptions)).constructor(RoadSnapTravelModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, SNAPPED_GEOMETRY_FORMAT_FIELD, SNAP_RADIUS_FIELD, TRACE_POINTS_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("key", KEY_FIELD);
            this.put("SnappedGeometryFormat", SNAPPED_GEOMETRY_FORMAT_FIELD);
            this.put("SnapRadius", SNAP_RADIUS_FIELD);
            this.put("TracePoints", TRACE_POINTS_FIELD);
            this.put("TravelMode", TRAVEL_MODE_FIELD);
            this.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        }
    });
    private final String key;
    private final String snappedGeometryFormat;
    private final Long snapRadius;
    private final List<RoadSnapTracePoint> tracePoints;
    private final String travelMode;
    private final RoadSnapTravelModeOptions travelModeOptions;

    private SnapToRoadsRequest(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.snappedGeometryFormat = builder.snappedGeometryFormat;
        this.snapRadius = builder.snapRadius;
        this.tracePoints = builder.tracePoints;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
    }

    public final String key() {
        return this.key;
    }

    public final GeometryFormat snappedGeometryFormat() {
        return GeometryFormat.fromValue(this.snappedGeometryFormat);
    }

    public final String snappedGeometryFormatAsString() {
        return this.snappedGeometryFormat;
    }

    public final Long snapRadius() {
        return this.snapRadius;
    }

    public final boolean hasTracePoints() {
        return this.tracePoints != null && !(this.tracePoints instanceof SdkAutoConstructList);
    }

    public final List<RoadSnapTracePoint> tracePoints() {
        return this.tracePoints;
    }

    public final RoadSnapTravelMode travelMode() {
        return RoadSnapTravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final RoadSnapTravelModeOptions travelModeOptions() {
        return this.travelModeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.snappedGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTracePoints() ? this.tracePoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapToRoadsRequest)) {
            return false;
        }
        SnapToRoadsRequest other = (SnapToRoadsRequest)((Object)obj);
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.snappedGeometryFormatAsString(), other.snappedGeometryFormatAsString()) && Objects.equals(this.snapRadius(), other.snapRadius()) && this.hasTracePoints() == other.hasTracePoints() && Objects.equals(this.tracePoints(), other.tracePoints()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.travelModeOptions(), other.travelModeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"SnapToRoadsRequest").add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("SnappedGeometryFormat", (Object)this.snappedGeometryFormatAsString()).add("SnapRadius", (Object)this.snapRadius()).add("TracePoints", this.hasTracePoints() ? this.tracePoints() : null).add("TravelMode", (Object)this.travelModeAsString()).add("TravelModeOptions", (Object)this.travelModeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "SnappedGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.snappedGeometryFormatAsString()));
            }
            case "SnapRadius": {
                return Optional.ofNullable(clazz.cast(this.snapRadius()));
            }
            case "TracePoints": {
                return Optional.ofNullable(clazz.cast(this.tracePoints()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TravelModeOptions": {
                return Optional.ofNullable(clazz.cast(this.travelModeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapToRoadsRequest, T> g) {
        return obj -> g.apply((SnapToRoadsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesRequest.BuilderImpl
    implements Builder {
        private String key;
        private String snappedGeometryFormat;
        private Long snapRadius;
        private List<RoadSnapTracePoint> tracePoints = DefaultSdkAutoConstructList.getInstance();
        private String travelMode;
        private RoadSnapTravelModeOptions travelModeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapToRoadsRequest model) {
            super(model);
            this.key(model.key);
            this.snappedGeometryFormat(model.snappedGeometryFormat);
            this.snapRadius(model.snapRadius);
            this.tracePoints(model.tracePoints);
            this.travelMode(model.travelMode);
            this.travelModeOptions(model.travelModeOptions);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getSnappedGeometryFormat() {
            return this.snappedGeometryFormat;
        }

        public final void setSnappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
        }

        @Override
        public final Builder snappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
            return this;
        }

        @Override
        public final Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat) {
            this.snappedGeometryFormat(snappedGeometryFormat == null ? null : snappedGeometryFormat.toString());
            return this;
        }

        public final Long getSnapRadius() {
            return this.snapRadius;
        }

        public final void setSnapRadius(Long snapRadius) {
            this.snapRadius = snapRadius;
        }

        @Override
        public final Builder snapRadius(Long snapRadius) {
            this.snapRadius = snapRadius;
            return this;
        }

        public final List<RoadSnapTracePoint.Builder> getTracePoints() {
            List<RoadSnapTracePoint.Builder> result = SnapToRoadsRequestTracePointsListCopier.copyToBuilder(this.tracePoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTracePoints(Collection<RoadSnapTracePoint.BuilderImpl> tracePoints) {
            this.tracePoints = SnapToRoadsRequestTracePointsListCopier.copyFromBuilder(tracePoints);
        }

        @Override
        public final Builder tracePoints(Collection<RoadSnapTracePoint> tracePoints) {
            this.tracePoints = SnapToRoadsRequestTracePointsListCopier.copy(tracePoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePoints(RoadSnapTracePoint ... tracePoints) {
            this.tracePoints(Arrays.asList(tracePoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePoints(Consumer<RoadSnapTracePoint.Builder> ... tracePoints) {
            this.tracePoints(Stream.of(tracePoints).map(c -> (RoadSnapTracePoint)((RoadSnapTracePoint.Builder)RoadSnapTracePoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RoadSnapTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final RoadSnapTravelModeOptions.Builder getTravelModeOptions() {
            return this.travelModeOptions != null ? this.travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(RoadSnapTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(RoadSnapTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SnapToRoadsRequest build() {
            return new SnapToRoadsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoRoutesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SnapToRoadsRequest> {
        public Builder key(String var1);

        public Builder snappedGeometryFormat(String var1);

        public Builder snappedGeometryFormat(GeometryFormat var1);

        public Builder snapRadius(Long var1);

        public Builder tracePoints(Collection<RoadSnapTracePoint> var1);

        public Builder tracePoints(RoadSnapTracePoint ... var1);

        public Builder tracePoints(Consumer<RoadSnapTracePoint.Builder> ... var1);

        public Builder travelMode(String var1);

        public Builder travelMode(RoadSnapTravelMode var1);

        public Builder travelModeOptions(RoadSnapTravelModeOptions var1);

        default public Builder travelModeOptions(Consumer<RoadSnapTravelModeOptions.Builder> travelModeOptions) {
            return this.travelModeOptions((RoadSnapTravelModeOptions)((RoadSnapTravelModeOptions.Builder)RoadSnapTravelModeOptions.builder().applyMutation(travelModeOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

