/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.BoundingBoxCopier;
import software.amazon.awssdk.services.georoutes.model.Corridor;
import software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometryPolygonListCopier;
import software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceAreaGeometryPolylinePolygonListCopier;
import software.amazon.awssdk.services.georoutes.model.PolylineCorridor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsolineAvoidanceAreaGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsolineAvoidanceAreaGeometry> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BoundingBox").getter(IsolineAvoidanceAreaGeometry.getter(IsolineAvoidanceAreaGeometry::boundingBox)).setter(IsolineAvoidanceAreaGeometry.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Corridor> CORRIDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Corridor").getter(IsolineAvoidanceAreaGeometry.getter(IsolineAvoidanceAreaGeometry::corridor)).setter(IsolineAvoidanceAreaGeometry.setter(Builder::corridor)).constructor(Corridor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Corridor").build()}).build();
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Polygon").getter(IsolineAvoidanceAreaGeometry.getter(IsolineAvoidanceAreaGeometry::polygon)).setter(IsolineAvoidanceAreaGeometry.setter(Builder::polygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<PolylineCorridor> POLYLINE_CORRIDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolylineCorridor").getter(IsolineAvoidanceAreaGeometry.getter(IsolineAvoidanceAreaGeometry::polylineCorridor)).setter(IsolineAvoidanceAreaGeometry.setter(Builder::polylineCorridor)).constructor(PolylineCorridor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolylineCorridor").build()}).build();
    private static final SdkField<List<String>> POLYLINE_POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolylinePolygon").getter(IsolineAvoidanceAreaGeometry.getter(IsolineAvoidanceAreaGeometry::polylinePolygon)).setter(IsolineAvoidanceAreaGeometry.setter(Builder::polylinePolygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolylinePolygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, CORRIDOR_FIELD, POLYGON_FIELD, POLYLINE_CORRIDOR_FIELD, POLYLINE_POLYGON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BoundingBox", BOUNDING_BOX_FIELD);
            this.put("Corridor", CORRIDOR_FIELD);
            this.put("Polygon", POLYGON_FIELD);
            this.put("PolylineCorridor", POLYLINE_CORRIDOR_FIELD);
            this.put("PolylinePolygon", POLYLINE_POLYGON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Double> boundingBox;
    private final Corridor corridor;
    private final List<List<List<Double>>> polygon;
    private final PolylineCorridor polylineCorridor;
    private final List<String> polylinePolygon;

    private IsolineAvoidanceAreaGeometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.corridor = builder.corridor;
        this.polygon = builder.polygon;
        this.polylineCorridor = builder.polylineCorridor;
        this.polylinePolygon = builder.polylinePolygon;
    }

    public final boolean hasBoundingBox() {
        return this.boundingBox != null && !(this.boundingBox instanceof SdkAutoConstructList);
    }

    public final List<Double> boundingBox() {
        return this.boundingBox;
    }

    public final Corridor corridor() {
        return this.corridor;
    }

    public final boolean hasPolygon() {
        return this.polygon != null && !(this.polygon instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> polygon() {
        return this.polygon;
    }

    public final PolylineCorridor polylineCorridor() {
        return this.polylineCorridor;
    }

    public final boolean hasPolylinePolygon() {
        return this.polylinePolygon != null && !(this.polylinePolygon instanceof SdkAutoConstructList);
    }

    public final List<String> polylinePolygon() {
        return this.polylinePolygon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoundingBox() ? this.boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.corridor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolygon() ? this.polygon() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.polylineCorridor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolylinePolygon() ? this.polylinePolygon() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineAvoidanceAreaGeometry)) {
            return false;
        }
        IsolineAvoidanceAreaGeometry other = (IsolineAvoidanceAreaGeometry)obj;
        return this.hasBoundingBox() == other.hasBoundingBox() && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.corridor(), other.corridor()) && this.hasPolygon() == other.hasPolygon() && Objects.equals(this.polygon(), other.polygon()) && Objects.equals(this.polylineCorridor(), other.polylineCorridor()) && this.hasPolylinePolygon() == other.hasPolylinePolygon() && Objects.equals(this.polylinePolygon(), other.polylinePolygon());
    }

    public final String toString() {
        return ToString.builder((String)"IsolineAvoidanceAreaGeometry").add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("Corridor", (Object)(this.corridor() == null ? null : "*** Sensitive Data Redacted ***")).add("Polygon", (Object)(this.polygon() == null ? null : "*** Sensitive Data Redacted ***")).add("PolylineCorridor", (Object)(this.polylineCorridor() == null ? null : "*** Sensitive Data Redacted ***")).add("PolylinePolygon", (Object)(this.polylinePolygon() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Corridor": {
                return Optional.ofNullable(clazz.cast(this.corridor()));
            }
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
            case "PolylineCorridor": {
                return Optional.ofNullable(clazz.cast(this.polylineCorridor()));
            }
            case "PolylinePolygon": {
                return Optional.ofNullable(clazz.cast(this.polylinePolygon()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsolineAvoidanceAreaGeometry, T> g) {
        return obj -> g.apply((IsolineAvoidanceAreaGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();
        private Corridor corridor;
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();
        private PolylineCorridor polylineCorridor;
        private List<String> polylinePolygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineAvoidanceAreaGeometry model) {
            this.boundingBox(model.boundingBox);
            this.corridor(model.corridor);
            this.polygon(model.polygon);
            this.polylineCorridor(model.polylineCorridor);
            this.polylinePolygon(model.polylinePolygon);
        }

        public final Collection<Double> getBoundingBox() {
            if (this.boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double ... boundingBox) {
            this.boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Corridor.Builder getCorridor() {
            return this.corridor != null ? this.corridor.toBuilder() : null;
        }

        public final void setCorridor(Corridor.BuilderImpl corridor) {
            this.corridor = corridor != null ? corridor.build() : null;
        }

        @Override
        public final Builder corridor(Corridor corridor) {
            this.corridor = corridor;
            return this;
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (this.polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = IsolineAvoidanceAreaGeometryPolygonListCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = IsolineAvoidanceAreaGeometryPolygonListCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>> ... polygon) {
            this.polygon((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(polygon));
            return this;
        }

        public final PolylineCorridor.Builder getPolylineCorridor() {
            return this.polylineCorridor != null ? this.polylineCorridor.toBuilder() : null;
        }

        public final void setPolylineCorridor(PolylineCorridor.BuilderImpl polylineCorridor) {
            this.polylineCorridor = polylineCorridor != null ? polylineCorridor.build() : null;
        }

        @Override
        public final Builder polylineCorridor(PolylineCorridor polylineCorridor) {
            this.polylineCorridor = polylineCorridor;
            return this;
        }

        public final Collection<String> getPolylinePolygon() {
            if (this.polylinePolygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polylinePolygon;
        }

        public final void setPolylinePolygon(Collection<String> polylinePolygon) {
            this.polylinePolygon = IsolineAvoidanceAreaGeometryPolylinePolygonListCopier.copy(polylinePolygon);
        }

        @Override
        public final Builder polylinePolygon(Collection<String> polylinePolygon) {
            this.polylinePolygon = IsolineAvoidanceAreaGeometryPolylinePolygonListCopier.copy(polylinePolygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polylinePolygon(String ... polylinePolygon) {
            this.polylinePolygon(Arrays.asList(polylinePolygon));
            return this;
        }

        public IsolineAvoidanceAreaGeometry build() {
            return new IsolineAvoidanceAreaGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsolineAvoidanceAreaGeometry> {
        public Builder boundingBox(Collection<Double> var1);

        public Builder boundingBox(Double ... var1);

        public Builder corridor(Corridor var1);

        default public Builder corridor(Consumer<Corridor.Builder> corridor) {
            return this.corridor((Corridor)((Corridor.Builder)Corridor.builder().applyMutation(corridor)).build());
        }

        public Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder polygon(Collection<? extends Collection<Double>> ... var1);

        public Builder polylineCorridor(PolylineCorridor var1);

        default public Builder polylineCorridor(Consumer<PolylineCorridor.Builder> polylineCorridor) {
            return this.polylineCorridor((PolylineCorridor)((PolylineCorridor.Builder)PolylineCorridor.builder().applyMutation(polylineCorridor)).build());
        }

        public Builder polylinePolygon(Collection<String> var1);

        public Builder polylinePolygon(String ... var1);
    }
}

