/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geoplaces.model.TypePlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreetComponents
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreetComponents> {
    private static final SdkField<String> BASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseName").getter(StreetComponents.getter(StreetComponents::baseName)).setter(StreetComponents.setter(Builder::baseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(StreetComponents.getter(StreetComponents::type)).setter(StreetComponents.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypePlacement").getter(StreetComponents.getter(StreetComponents::typePlacementAsString)).setter(StreetComponents.setter(Builder::typePlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypePlacement").build()}).build();
    private static final SdkField<String> TYPE_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeSeparator").getter(StreetComponents.getter(StreetComponents::typeSeparator)).setter(StreetComponents.setter(Builder::typeSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeSeparator").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(StreetComponents.getter(StreetComponents::prefix)).setter(StreetComponents.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Suffix").getter(StreetComponents.getter(StreetComponents::suffix)).setter(StreetComponents.setter(Builder::suffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(StreetComponents.getter(StreetComponents::direction)).setter(StreetComponents.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(StreetComponents.getter(StreetComponents::language)).setter(StreetComponents.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_NAME_FIELD, TYPE_FIELD, TYPE_PLACEMENT_FIELD, TYPE_SEPARATOR_FIELD, PREFIX_FIELD, SUFFIX_FIELD, DIRECTION_FIELD, LANGUAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String baseName;
    private final String type;
    private final String typePlacement;
    private final String typeSeparator;
    private final String prefix;
    private final String suffix;
    private final String direction;
    private final String language;

    private StreetComponents(BuilderImpl builder) {
        this.baseName = builder.baseName;
        this.type = builder.type;
        this.typePlacement = builder.typePlacement;
        this.typeSeparator = builder.typeSeparator;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.direction = builder.direction;
        this.language = builder.language;
    }

    public final String baseName() {
        return this.baseName;
    }

    public final String type() {
        return this.type;
    }

    public final TypePlacement typePlacement() {
        return TypePlacement.fromValue(this.typePlacement);
    }

    public final String typePlacementAsString() {
        return this.typePlacement;
    }

    public final String typeSeparator() {
        return this.typeSeparator;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String suffix() {
        return this.suffix;
    }

    public final String direction() {
        return this.direction;
    }

    public final String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.typePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.suffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.direction());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreetComponents)) {
            return false;
        }
        StreetComponents other = (StreetComponents)obj;
        return Objects.equals(this.baseName(), other.baseName()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.typePlacementAsString(), other.typePlacementAsString()) && Objects.equals(this.typeSeparator(), other.typeSeparator()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.suffix(), other.suffix()) && Objects.equals(this.direction(), other.direction()) && Objects.equals(this.language(), other.language());
    }

    public final String toString() {
        return ToString.builder((String)"StreetComponents").add("BaseName", (Object)this.baseName()).add("Type", (Object)this.type()).add("TypePlacement", (Object)this.typePlacementAsString()).add("TypeSeparator", (Object)this.typeSeparator()).add("Prefix", (Object)this.prefix()).add("Suffix", (Object)this.suffix()).add("Direction", (Object)this.direction()).add("Language", (Object)this.language()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseName": {
                return Optional.ofNullable(clazz.cast(this.baseName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "TypePlacement": {
                return Optional.ofNullable(clazz.cast(this.typePlacementAsString()));
            }
            case "TypeSeparator": {
                return Optional.ofNullable(clazz.cast(this.typeSeparator()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Suffix": {
                return Optional.ofNullable(clazz.cast(this.suffix()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.direction()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreetComponents, T> g) {
        return obj -> g.apply((StreetComponents)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseName;
        private String type;
        private String typePlacement;
        private String typeSeparator;
        private String prefix;
        private String suffix;
        private String direction;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(StreetComponents model) {
            this.baseName(model.baseName);
            this.type(model.type);
            this.typePlacement(model.typePlacement);
            this.typeSeparator(model.typeSeparator);
            this.prefix(model.prefix);
            this.suffix(model.suffix);
            this.direction(model.direction);
            this.language(model.language);
        }

        public final String getBaseName() {
            return this.baseName;
        }

        public final void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        @Override
        public final Builder baseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypePlacement() {
            return this.typePlacement;
        }

        public final void setTypePlacement(String typePlacement) {
            this.typePlacement = typePlacement;
        }

        @Override
        public final Builder typePlacement(String typePlacement) {
            this.typePlacement = typePlacement;
            return this;
        }

        @Override
        public final Builder typePlacement(TypePlacement typePlacement) {
            this.typePlacement(typePlacement == null ? null : typePlacement.toString());
            return this;
        }

        public final String getTypeSeparator() {
            return this.typeSeparator;
        }

        public final void setTypeSeparator(String typeSeparator) {
            this.typeSeparator = typeSeparator;
        }

        @Override
        public final Builder typeSeparator(String typeSeparator) {
            this.typeSeparator = typeSeparator;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return this.suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public StreetComponents build() {
            return new StreetComponents(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreetComponents> {
        public Builder baseName(String var1);

        public Builder type(String var1);

        public Builder typePlacement(String var1);

        public Builder typePlacement(TypePlacement var1);

        public Builder typeSeparator(String var1);

        public Builder prefix(String var1);

        public Builder suffix(String var1);

        public Builder direction(String var1);

        public Builder language(String var1);
    }
}

