/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesResponse;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItem;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchNearbyResponse
extends GeoPlacesResponse
implements ToCopyableBuilder<Builder, SearchNearbyResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(SearchNearbyResponse.getter(SearchNearbyResponse::pricingBucket)).setter(SearchNearbyResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<SearchNearbyResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(SearchNearbyResponse.getter(SearchNearbyResponse::resultItems)).setter(SearchNearbyResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchNearbyResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchNearbyResponse.getter(SearchNearbyResponse::nextToken)).setter(SearchNearbyResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD, RESULT_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final String pricingBucket;
    private final List<SearchNearbyResultItem> resultItems;
    private final String nextToken;

    private SearchNearbyResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
        this.nextToken = builder.nextToken;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<SearchNearbyResultItem> resultItems() {
        return this.resultItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyResponse)) {
            return false;
        }
        SearchNearbyResponse other = (SearchNearbyResponse)((Object)obj);
        return Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchNearbyResponse").add("PricingBucket", (Object)this.pricingBucket()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyResponse, T> g) {
        return obj -> g.apply((SearchNearbyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesResponse.BuilderImpl
    implements Builder {
        private String pricingBucket;
        private List<SearchNearbyResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyResponse model) {
            super(model);
            this.pricingBucket(model.pricingBucket);
            this.resultItems(model.resultItems);
            this.nextToken(model.nextToken);
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<SearchNearbyResultItem.Builder> getResultItems() {
            List<SearchNearbyResultItem.Builder> result = SearchNearbyResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<SearchNearbyResultItem.BuilderImpl> resultItems) {
            this.resultItems = SearchNearbyResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<SearchNearbyResultItem> resultItems) {
            this.resultItems = SearchNearbyResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(SearchNearbyResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<SearchNearbyResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (SearchNearbyResultItem)((SearchNearbyResultItem.Builder)SearchNearbyResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchNearbyResponse build() {
            return new SearchNearbyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GeoPlacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchNearbyResponse> {
        public Builder pricingBucket(String var1);

        public Builder resultItems(Collection<SearchNearbyResultItem> var1);

        public Builder resultItems(SearchNearbyResultItem ... var1);

        public Builder resultItems(Consumer<SearchNearbyResultItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

