/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.CountryCodeListCopier;
import software.amazon.awssdk.services.geoplaces.model.GeocodeFilterPlaceType;
import software.amazon.awssdk.services.geoplaces.model.GeocodeFilterPlaceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeocodeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeocodeFilter> {
    private static final SdkField<List<String>> INCLUDE_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeCountries").getter(GeocodeFilter.getter(GeocodeFilter::includeCountries)).setter(GeocodeFilter.setter(Builder::includeCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_PLACE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludePlaceTypes").getter(GeocodeFilter.getter(GeocodeFilter::includePlaceTypesAsStrings)).setter(GeocodeFilter.setter(Builder::includePlaceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePlaceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_COUNTRIES_FIELD, INCLUDE_PLACE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> includeCountries;
    private final List<String> includePlaceTypes;

    private GeocodeFilter(BuilderImpl builder) {
        this.includeCountries = builder.includeCountries;
        this.includePlaceTypes = builder.includePlaceTypes;
    }

    public final boolean hasIncludeCountries() {
        return this.includeCountries != null && !(this.includeCountries instanceof SdkAutoConstructList);
    }

    public final List<String> includeCountries() {
        return this.includeCountries;
    }

    public final List<GeocodeFilterPlaceType> includePlaceTypes() {
        return GeocodeFilterPlaceTypeListCopier.copyStringToEnum(this.includePlaceTypes);
    }

    public final boolean hasIncludePlaceTypes() {
        return this.includePlaceTypes != null && !(this.includePlaceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> includePlaceTypesAsStrings() {
        return this.includePlaceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeCountries() ? this.includeCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludePlaceTypes() ? this.includePlaceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeFilter)) {
            return false;
        }
        GeocodeFilter other = (GeocodeFilter)obj;
        return this.hasIncludeCountries() == other.hasIncludeCountries() && Objects.equals(this.includeCountries(), other.includeCountries()) && this.hasIncludePlaceTypes() == other.hasIncludePlaceTypes() && Objects.equals(this.includePlaceTypesAsStrings(), other.includePlaceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GeocodeFilter").add("IncludeCountries", this.hasIncludeCountries() ? this.includeCountries() : null).add("IncludePlaceTypes", this.hasIncludePlaceTypes() ? this.includePlaceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncludeCountries": {
                return Optional.ofNullable(clazz.cast(this.includeCountries()));
            }
            case "IncludePlaceTypes": {
                return Optional.ofNullable(clazz.cast(this.includePlaceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeocodeFilter, T> g) {
        return obj -> g.apply((GeocodeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> includeCountries = DefaultSdkAutoConstructList.getInstance();
        private List<String> includePlaceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeFilter model) {
            this.includeCountries(model.includeCountries);
            this.includePlaceTypesWithStrings(model.includePlaceTypes);
        }

        public final Collection<String> getIncludeCountries() {
            if (this.includeCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeCountries;
        }

        public final void setIncludeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
        }

        @Override
        public final Builder includeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCountries(String ... includeCountries) {
            this.includeCountries(Arrays.asList(includeCountries));
            return this;
        }

        public final Collection<String> getIncludePlaceTypes() {
            if (this.includePlaceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includePlaceTypes;
        }

        public final void setIncludePlaceTypes(Collection<String> includePlaceTypes) {
            this.includePlaceTypes = GeocodeFilterPlaceTypeListCopier.copy(includePlaceTypes);
        }

        @Override
        public final Builder includePlaceTypesWithStrings(Collection<String> includePlaceTypes) {
            this.includePlaceTypes = GeocodeFilterPlaceTypeListCopier.copy(includePlaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includePlaceTypesWithStrings(String ... includePlaceTypes) {
            this.includePlaceTypesWithStrings(Arrays.asList(includePlaceTypes));
            return this;
        }

        @Override
        public final Builder includePlaceTypes(Collection<GeocodeFilterPlaceType> includePlaceTypes) {
            this.includePlaceTypes = GeocodeFilterPlaceTypeListCopier.copyEnumToString(includePlaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includePlaceTypes(GeocodeFilterPlaceType ... includePlaceTypes) {
            this.includePlaceTypes(Arrays.asList(includePlaceTypes));
            return this;
        }

        public GeocodeFilter build() {
            return new GeocodeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeocodeFilter> {
        public Builder includeCountries(Collection<String> var1);

        public Builder includeCountries(String ... var1);

        public Builder includePlaceTypesWithStrings(Collection<String> var1);

        public Builder includePlaceTypesWithStrings(String ... var1);

        public Builder includePlaceTypes(Collection<GeocodeFilterPlaceType> var1);

        public Builder includePlaceTypes(GeocodeFilterPlaceType ... var1);
    }
}

