/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.ContactDetails;
import software.amazon.awssdk.services.geoplaces.model.ContactDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Contacts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Contacts> {
    private static final SdkField<List<ContactDetails>> PHONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phones").getter(Contacts.getter(Contacts::phones)).setter(Contacts.setter(Builder::phones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactDetails>> FAXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Faxes").getter(Contacts.getter(Contacts::faxes)).setter(Contacts.setter(Builder::faxes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faxes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactDetails>> WEBSITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Websites").getter(Contacts.getter(Contacts::websites)).setter(Contacts.setter(Builder::websites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Websites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactDetails>> EMAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Emails").getter(Contacts.getter(Contacts::emails)).setter(Contacts.setter(Builder::emails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONES_FIELD, FAXES_FIELD, WEBSITES_FIELD, EMAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ContactDetails> phones;
    private final List<ContactDetails> faxes;
    private final List<ContactDetails> websites;
    private final List<ContactDetails> emails;

    private Contacts(BuilderImpl builder) {
        this.phones = builder.phones;
        this.faxes = builder.faxes;
        this.websites = builder.websites;
        this.emails = builder.emails;
    }

    public final boolean hasPhones() {
        return this.phones != null && !(this.phones instanceof SdkAutoConstructList);
    }

    public final List<ContactDetails> phones() {
        return this.phones;
    }

    public final boolean hasFaxes() {
        return this.faxes != null && !(this.faxes instanceof SdkAutoConstructList);
    }

    public final List<ContactDetails> faxes() {
        return this.faxes;
    }

    public final boolean hasWebsites() {
        return this.websites != null && !(this.websites instanceof SdkAutoConstructList);
    }

    public final List<ContactDetails> websites() {
        return this.websites;
    }

    public final boolean hasEmails() {
        return this.emails != null && !(this.emails instanceof SdkAutoConstructList);
    }

    public final List<ContactDetails> emails() {
        return this.emails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhones() ? this.phones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaxes() ? this.faxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebsites() ? this.websites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmails() ? this.emails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contacts)) {
            return false;
        }
        Contacts other = (Contacts)obj;
        return this.hasPhones() == other.hasPhones() && Objects.equals(this.phones(), other.phones()) && this.hasFaxes() == other.hasFaxes() && Objects.equals(this.faxes(), other.faxes()) && this.hasWebsites() == other.hasWebsites() && Objects.equals(this.websites(), other.websites()) && this.hasEmails() == other.hasEmails() && Objects.equals(this.emails(), other.emails());
    }

    public final String toString() {
        return ToString.builder((String)"Contacts").add("Phones", this.hasPhones() ? this.phones() : null).add("Faxes", this.hasFaxes() ? this.faxes() : null).add("Websites", this.hasWebsites() ? this.websites() : null).add("Emails", this.hasEmails() ? this.emails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Phones": {
                return Optional.ofNullable(clazz.cast(this.phones()));
            }
            case "Faxes": {
                return Optional.ofNullable(clazz.cast(this.faxes()));
            }
            case "Websites": {
                return Optional.ofNullable(clazz.cast(this.websites()));
            }
            case "Emails": {
                return Optional.ofNullable(clazz.cast(this.emails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Contacts, T> g) {
        return obj -> g.apply((Contacts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContactDetails> phones = DefaultSdkAutoConstructList.getInstance();
        private List<ContactDetails> faxes = DefaultSdkAutoConstructList.getInstance();
        private List<ContactDetails> websites = DefaultSdkAutoConstructList.getInstance();
        private List<ContactDetails> emails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Contacts model) {
            this.phones(model.phones);
            this.faxes(model.faxes);
            this.websites(model.websites);
            this.emails(model.emails);
        }

        public final List<ContactDetails.Builder> getPhones() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.phones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhones(Collection<ContactDetails.BuilderImpl> phones) {
            this.phones = ContactDetailsListCopier.copyFromBuilder(phones);
        }

        @Override
        public final Builder phones(Collection<ContactDetails> phones) {
            this.phones = ContactDetailsListCopier.copy(phones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phones(ContactDetails ... phones) {
            this.phones(Arrays.asList(phones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phones(Consumer<ContactDetails.Builder> ... phones) {
            this.phones(Stream.of(phones).map(c -> (ContactDetails)((ContactDetails.Builder)ContactDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getFaxes() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.faxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaxes(Collection<ContactDetails.BuilderImpl> faxes) {
            this.faxes = ContactDetailsListCopier.copyFromBuilder(faxes);
        }

        @Override
        public final Builder faxes(Collection<ContactDetails> faxes) {
            this.faxes = ContactDetailsListCopier.copy(faxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faxes(ContactDetails ... faxes) {
            this.faxes(Arrays.asList(faxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faxes(Consumer<ContactDetails.Builder> ... faxes) {
            this.faxes(Stream.of(faxes).map(c -> (ContactDetails)((ContactDetails.Builder)ContactDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getWebsites() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.websites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebsites(Collection<ContactDetails.BuilderImpl> websites) {
            this.websites = ContactDetailsListCopier.copyFromBuilder(websites);
        }

        @Override
        public final Builder websites(Collection<ContactDetails> websites) {
            this.websites = ContactDetailsListCopier.copy(websites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websites(ContactDetails ... websites) {
            this.websites(Arrays.asList(websites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websites(Consumer<ContactDetails.Builder> ... websites) {
            this.websites(Stream.of(websites).map(c -> (ContactDetails)((ContactDetails.Builder)ContactDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getEmails() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.emails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmails(Collection<ContactDetails.BuilderImpl> emails) {
            this.emails = ContactDetailsListCopier.copyFromBuilder(emails);
        }

        @Override
        public final Builder emails(Collection<ContactDetails> emails) {
            this.emails = ContactDetailsListCopier.copy(emails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(ContactDetails ... emails) {
            this.emails(Arrays.asList(emails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Consumer<ContactDetails.Builder> ... emails) {
            this.emails(Stream.of(emails).map(c -> (ContactDetails)((ContactDetails.Builder)ContactDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Contacts build() {
            return new Contacts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Contacts> {
        public Builder phones(Collection<ContactDetails> var1);

        public Builder phones(ContactDetails ... var1);

        public Builder phones(Consumer<ContactDetails.Builder> ... var1);

        public Builder faxes(Collection<ContactDetails> var1);

        public Builder faxes(ContactDetails ... var1);

        public Builder faxes(Consumer<ContactDetails.Builder> ... var1);

        public Builder websites(Collection<ContactDetails> var1);

        public Builder websites(ContactDetails ... var1);

        public Builder websites(Consumer<ContactDetails.Builder> ... var1);

        public Builder emails(Collection<ContactDetails> var1);

        public Builder emails(ContactDetails ... var1);

        public Builder emails(Consumer<ContactDetails.Builder> ... var1);
    }
}

