/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geoplaces.model.PostalAuthority;
import software.amazon.awssdk.services.geoplaces.model.PostalCodeType;
import software.amazon.awssdk.services.geoplaces.model.UspsZip;
import software.amazon.awssdk.services.geoplaces.model.UspsZipPlus4;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostalCodeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PostalCodeDetails> {
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(PostalCodeDetails.getter(PostalCodeDetails::postalCode)).setter(PostalCodeDetails.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> POSTAL_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalAuthority").getter(PostalCodeDetails.getter(PostalCodeDetails::postalAuthorityAsString)).setter(PostalCodeDetails.setter(Builder::postalAuthority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalAuthority").build()}).build();
    private static final SdkField<String> POSTAL_CODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCodeType").getter(PostalCodeDetails.getter(PostalCodeDetails::postalCodeTypeAsString)).setter(PostalCodeDetails.setter(Builder::postalCodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCodeType").build()}).build();
    private static final SdkField<UspsZip> USPS_ZIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UspsZip").getter(PostalCodeDetails.getter(PostalCodeDetails::uspsZip)).setter(PostalCodeDetails.setter(Builder::uspsZip)).constructor(UspsZip::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UspsZip").build()}).build();
    private static final SdkField<UspsZipPlus4> USPS_ZIP_PLUS4_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UspsZipPlus4").getter(PostalCodeDetails.getter(PostalCodeDetails::uspsZipPlus4)).setter(PostalCodeDetails.setter(Builder::uspsZipPlus4)).constructor(UspsZipPlus4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UspsZipPlus4").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSTAL_CODE_FIELD, POSTAL_AUTHORITY_FIELD, POSTAL_CODE_TYPE_FIELD, USPS_ZIP_FIELD, USPS_ZIP_PLUS4_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PostalCodeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String postalCode;
    private final String postalAuthority;
    private final String postalCodeType;
    private final UspsZip uspsZip;
    private final UspsZipPlus4 uspsZipPlus4;

    private PostalCodeDetails(BuilderImpl builder) {
        this.postalCode = builder.postalCode;
        this.postalAuthority = builder.postalAuthority;
        this.postalCodeType = builder.postalCodeType;
        this.uspsZip = builder.uspsZip;
        this.uspsZipPlus4 = builder.uspsZipPlus4;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final PostalAuthority postalAuthority() {
        return PostalAuthority.fromValue(this.postalAuthority);
    }

    public final String postalAuthorityAsString() {
        return this.postalAuthority;
    }

    public final PostalCodeType postalCodeType() {
        return PostalCodeType.fromValue(this.postalCodeType);
    }

    public final String postalCodeTypeAsString() {
        return this.postalCodeType;
    }

    public final UspsZip uspsZip() {
        return this.uspsZip;
    }

    public final UspsZipPlus4 uspsZipPlus4() {
        return this.uspsZipPlus4;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalAuthorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uspsZip());
        hashCode = 31 * hashCode + Objects.hashCode(this.uspsZipPlus4());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostalCodeDetails)) {
            return false;
        }
        PostalCodeDetails other = (PostalCodeDetails)obj;
        return Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.postalAuthorityAsString(), other.postalAuthorityAsString()) && Objects.equals(this.postalCodeTypeAsString(), other.postalCodeTypeAsString()) && Objects.equals(this.uspsZip(), other.uspsZip()) && Objects.equals(this.uspsZipPlus4(), other.uspsZipPlus4());
    }

    public final String toString() {
        return ToString.builder((String)"PostalCodeDetails").add("PostalCode", (Object)this.postalCode()).add("PostalAuthority", (Object)this.postalAuthorityAsString()).add("PostalCodeType", (Object)this.postalCodeTypeAsString()).add("UspsZip", (Object)this.uspsZip()).add("UspsZipPlus4", (Object)this.uspsZipPlus4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "PostalAuthority": {
                return Optional.ofNullable(clazz.cast(this.postalAuthorityAsString()));
            }
            case "PostalCodeType": {
                return Optional.ofNullable(clazz.cast(this.postalCodeTypeAsString()));
            }
            case "UspsZip": {
                return Optional.ofNullable(clazz.cast(this.uspsZip()));
            }
            case "UspsZipPlus4": {
                return Optional.ofNullable(clazz.cast(this.uspsZipPlus4()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("PostalAuthority", POSTAL_AUTHORITY_FIELD);
        map.put("PostalCodeType", POSTAL_CODE_TYPE_FIELD);
        map.put("UspsZip", USPS_ZIP_FIELD);
        map.put("UspsZipPlus4", USPS_ZIP_PLUS4_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostalCodeDetails, T> g) {
        return obj -> g.apply((PostalCodeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String postalCode;
        private String postalAuthority;
        private String postalCodeType;
        private UspsZip uspsZip;
        private UspsZipPlus4 uspsZipPlus4;

        private BuilderImpl() {
        }

        private BuilderImpl(PostalCodeDetails model) {
            this.postalCode(model.postalCode);
            this.postalAuthority(model.postalAuthority);
            this.postalCodeType(model.postalCodeType);
            this.uspsZip(model.uspsZip);
            this.uspsZipPlus4(model.uspsZipPlus4);
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getPostalAuthority() {
            return this.postalAuthority;
        }

        public final void setPostalAuthority(String postalAuthority) {
            this.postalAuthority = postalAuthority;
        }

        @Override
        public final Builder postalAuthority(String postalAuthority) {
            this.postalAuthority = postalAuthority;
            return this;
        }

        @Override
        public final Builder postalAuthority(PostalAuthority postalAuthority) {
            this.postalAuthority(postalAuthority == null ? null : postalAuthority.toString());
            return this;
        }

        public final String getPostalCodeType() {
            return this.postalCodeType;
        }

        public final void setPostalCodeType(String postalCodeType) {
            this.postalCodeType = postalCodeType;
        }

        @Override
        public final Builder postalCodeType(String postalCodeType) {
            this.postalCodeType = postalCodeType;
            return this;
        }

        @Override
        public final Builder postalCodeType(PostalCodeType postalCodeType) {
            this.postalCodeType(postalCodeType == null ? null : postalCodeType.toString());
            return this;
        }

        public final UspsZip.Builder getUspsZip() {
            return this.uspsZip != null ? this.uspsZip.toBuilder() : null;
        }

        public final void setUspsZip(UspsZip.BuilderImpl uspsZip) {
            this.uspsZip = uspsZip != null ? uspsZip.build() : null;
        }

        @Override
        public final Builder uspsZip(UspsZip uspsZip) {
            this.uspsZip = uspsZip;
            return this;
        }

        public final UspsZipPlus4.Builder getUspsZipPlus4() {
            return this.uspsZipPlus4 != null ? this.uspsZipPlus4.toBuilder() : null;
        }

        public final void setUspsZipPlus4(UspsZipPlus4.BuilderImpl uspsZipPlus4) {
            this.uspsZipPlus4 = uspsZipPlus4 != null ? uspsZipPlus4.build() : null;
        }

        @Override
        public final Builder uspsZipPlus4(UspsZipPlus4 uspsZipPlus4) {
            this.uspsZipPlus4 = uspsZipPlus4;
            return this;
        }

        public PostalCodeDetails build() {
            return new PostalCodeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PostalCodeDetails> {
        public Builder postalCode(String var1);

        public Builder postalAuthority(String var1);

        public Builder postalAuthority(PostalAuthority var1);

        public Builder postalCodeType(String var1);

        public Builder postalCodeType(PostalCodeType var1);

        public Builder uspsZip(UspsZip var1);

        default public Builder uspsZip(Consumer<UspsZip.Builder> uspsZip) {
            return this.uspsZip((UspsZip)((UspsZip.Builder)UspsZip.builder().applyMutation(uspsZip)).build());
        }

        public Builder uspsZipPlus4(UspsZipPlus4 var1);

        default public Builder uspsZipPlus4(Consumer<UspsZipPlus4.Builder> uspsZipPlus4) {
            return this.uspsZipPlus4((UspsZipPlus4)((UspsZipPlus4.Builder)UspsZipPlus4.builder().applyMutation(uspsZipPlus4)).build());
        }
    }
}

