/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Country
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Country> {
    private static final SdkField<String> CODE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code2").getter(Country.getter(Country::code2)).setter(Country.setter(Builder::code2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code2").build()}).build();
    private static final SdkField<String> CODE3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code3").getter(Country.getter(Country::code3)).setter(Country.setter(Builder::code3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code3").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Country.getter(Country::name)).setter(Country.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE2_FIELD, CODE3_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Country.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code2;
    private final String code3;
    private final String name;

    private Country(BuilderImpl builder) {
        this.code2 = builder.code2;
        this.code3 = builder.code3;
        this.name = builder.name;
    }

    public final String code2() {
        return this.code2;
    }

    public final String code3() {
        return this.code3;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code2());
        hashCode = 31 * hashCode + Objects.hashCode(this.code3());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Country)) {
            return false;
        }
        Country other = (Country)obj;
        return Objects.equals(this.code2(), other.code2()) && Objects.equals(this.code3(), other.code3()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"Country").add("Code2", (Object)this.code2()).add("Code3", (Object)this.code3()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code2": {
                return Optional.ofNullable(clazz.cast(this.code2()));
            }
            case "Code3": {
                return Optional.ofNullable(clazz.cast(this.code3()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Code2", CODE2_FIELD);
        map.put("Code3", CODE3_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Country, T> g) {
        return obj -> g.apply((Country)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code2;
        private String code3;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Country model) {
            this.code2(model.code2);
            this.code3(model.code3);
            this.name(model.name);
        }

        public final String getCode2() {
            return this.code2;
        }

        public final void setCode2(String code2) {
            this.code2 = code2;
        }

        @Override
        public final Builder code2(String code2) {
            this.code2 = code2;
            return this;
        }

        public final String getCode3() {
            return this.code3;
        }

        public final void setCode3(String code3) {
            this.code3 = code3;
        }

        @Override
        public final Builder code3(String code3) {
            this.code3 = code3;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public Country build() {
            return new Country(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Country> {
        public Builder code2(String var1);

        public Builder code3(String var1);

        public Builder name(String var1);
    }
}

