/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamesparks.model.GameSummary;
import software.amazon.awssdk.services.gamesparks.model.ListGamesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGamesResponse;

public class ListGamesPublisher
implements SdkPublisher<ListGamesResponse> {
    private final GameSparksAsyncClient client;
    private final ListGamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGamesPublisher(GameSparksAsyncClient client, ListGamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGamesPublisher(GameSparksAsyncClient client, ListGamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameSummary> games() {
        Function<ListGamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.games() != null) {
                return response.games().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGamesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGamesResponseFetcher
    implements AsyncPageFetcher<ListGamesResponse> {
        private ListGamesResponseFetcher() {
        }

        public boolean hasNextPage(ListGamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGamesResponse> nextPage(ListGamesResponse previousPage) {
            if (previousPage == null) {
                return ListGamesPublisher.this.client.listGames(ListGamesPublisher.this.firstRequest);
            }
            return ListGamesPublisher.this.client.listGames((ListGamesRequest)((Object)ListGamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

