/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExtensionVersionRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, GetExtensionVersionRequest> {
    private static final SdkField<String> EXTENSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionVersion").getter(GetExtensionVersionRequest.getter(GetExtensionVersionRequest::extensionVersion)).setter(GetExtensionVersionRequest.setter(Builder::extensionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ExtensionVersion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetExtensionVersionRequest.getter(GetExtensionVersionRequest::name)).setter(GetExtensionVersionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetExtensionVersionRequest.getter(GetExtensionVersionRequest::namespace)).setter(GetExtensionVersionRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_VERSION_FIELD, NAME_FIELD, NAMESPACE_FIELD));
    private final String extensionVersion;
    private final String name;
    private final String namespace;

    private GetExtensionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.extensionVersion = builder.extensionVersion;
        this.name = builder.name;
        this.namespace = builder.namespace;
    }

    public final String extensionVersion() {
        return this.extensionVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExtensionVersionRequest)) {
            return false;
        }
        GetExtensionVersionRequest other = (GetExtensionVersionRequest)((Object)obj);
        return Objects.equals(this.extensionVersion(), other.extensionVersion()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"GetExtensionVersionRequest").add("ExtensionVersion", (Object)this.extensionVersion()).add("Name", (Object)this.name()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionVersion": {
                return Optional.ofNullable(clazz.cast(this.extensionVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExtensionVersionRequest, T> g) {
        return obj -> g.apply((GetExtensionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String extensionVersion;
        private String name;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExtensionVersionRequest model) {
            super(model);
            this.extensionVersion(model.extensionVersion);
            this.name(model.name);
            this.namespace(model.namespace);
        }

        public final String getExtensionVersion() {
            return this.extensionVersion;
        }

        public final void setExtensionVersion(String extensionVersion) {
            this.extensionVersion = extensionVersion;
        }

        @Override
        public final Builder extensionVersion(String extensionVersion) {
            this.extensionVersion = extensionVersion;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExtensionVersionRequest build() {
            return new GetExtensionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExtensionVersionRequest> {
        public Builder extensionVersion(String var1);

        public Builder name(String var1);

        public Builder namespace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

