/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisconnectPlayerResponse extends GameSparksResponse implements
        ToCopyableBuilder<DisconnectPlayerResponse.Builder, DisconnectPlayerResponse> {
    private static final SdkField<List<String>> DISCONNECT_FAILURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisconnectFailures")
            .getter(getter(DisconnectPlayerResponse::disconnectFailures))
            .setter(setter(Builder::disconnectFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectFailures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISCONNECT_SUCCESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisconnectSuccesses")
            .getter(getter(DisconnectPlayerResponse::disconnectSuccesses))
            .setter(setter(Builder::disconnectSuccesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectSuccesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCONNECT_FAILURES_FIELD,
            DISCONNECT_SUCCESSES_FIELD));

    private final List<String> disconnectFailures;

    private final List<String> disconnectSuccesses;

    private DisconnectPlayerResponse(BuilderImpl builder) {
        super(builder);
        this.disconnectFailures = builder.disconnectFailures;
        this.disconnectSuccesses = builder.disconnectSuccesses;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisconnectFailures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisconnectFailures() {
        return disconnectFailures != null && !(disconnectFailures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the connection ids that could not be disconnected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisconnectFailures} method.
     * </p>
     * 
     * @return The list of the connection ids that could not be disconnected.
     */
    public final List<String> disconnectFailures() {
        return disconnectFailures;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisconnectSuccesses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisconnectSuccesses() {
        return disconnectSuccesses != null && !(disconnectSuccesses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the connection ids that were disconnected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisconnectSuccesses} method.
     * </p>
     * 
     * @return The list of the connection ids that were disconnected.
     */
    public final List<String> disconnectSuccesses() {
        return disconnectSuccesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDisconnectFailures() ? disconnectFailures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisconnectSuccesses() ? disconnectSuccesses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectPlayerResponse)) {
            return false;
        }
        DisconnectPlayerResponse other = (DisconnectPlayerResponse) obj;
        return hasDisconnectFailures() == other.hasDisconnectFailures()
                && Objects.equals(disconnectFailures(), other.disconnectFailures())
                && hasDisconnectSuccesses() == other.hasDisconnectSuccesses()
                && Objects.equals(disconnectSuccesses(), other.disconnectSuccesses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectPlayerResponse")
                .add("DisconnectFailures", hasDisconnectFailures() ? disconnectFailures() : null)
                .add("DisconnectSuccesses", hasDisconnectSuccesses() ? disconnectSuccesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisconnectFailures":
            return Optional.ofNullable(clazz.cast(disconnectFailures()));
        case "DisconnectSuccesses":
            return Optional.ofNullable(clazz.cast(disconnectSuccesses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisconnectPlayerResponse, T> g) {
        return obj -> g.apply((DisconnectPlayerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisconnectPlayerResponse> {
        /**
         * <p>
         * The list of the connection ids that could not be disconnected.
         * </p>
         * 
         * @param disconnectFailures
         *        The list of the connection ids that could not be disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectFailures(Collection<String> disconnectFailures);

        /**
         * <p>
         * The list of the connection ids that could not be disconnected.
         * </p>
         * 
         * @param disconnectFailures
         *        The list of the connection ids that could not be disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectFailures(String... disconnectFailures);

        /**
         * <p>
         * The list of the connection ids that were disconnected.
         * </p>
         * 
         * @param disconnectSuccesses
         *        The list of the connection ids that were disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectSuccesses(Collection<String> disconnectSuccesses);

        /**
         * <p>
         * The list of the connection ids that were disconnected.
         * </p>
         * 
         * @param disconnectSuccesses
         *        The list of the connection ids that were disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectSuccesses(String... disconnectSuccesses);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private List<String> disconnectFailures = DefaultSdkAutoConstructList.getInstance();

        private List<String> disconnectSuccesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectPlayerResponse model) {
            super(model);
            disconnectFailures(model.disconnectFailures);
            disconnectSuccesses(model.disconnectSuccesses);
        }

        public final Collection<String> getDisconnectFailures() {
            if (disconnectFailures instanceof SdkAutoConstructList) {
                return null;
            }
            return disconnectFailures;
        }

        public final void setDisconnectFailures(Collection<String> disconnectFailures) {
            this.disconnectFailures = ConnectionIdListCopier.copy(disconnectFailures);
        }

        @Override
        public final Builder disconnectFailures(Collection<String> disconnectFailures) {
            this.disconnectFailures = ConnectionIdListCopier.copy(disconnectFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectFailures(String... disconnectFailures) {
            disconnectFailures(Arrays.asList(disconnectFailures));
            return this;
        }

        public final Collection<String> getDisconnectSuccesses() {
            if (disconnectSuccesses instanceof SdkAutoConstructList) {
                return null;
            }
            return disconnectSuccesses;
        }

        public final void setDisconnectSuccesses(Collection<String> disconnectSuccesses) {
            this.disconnectSuccesses = ConnectionIdListCopier.copy(disconnectSuccesses);
        }

        @Override
        public final Builder disconnectSuccesses(Collection<String> disconnectSuccesses) {
            this.disconnectSuccesses = ConnectionIdListCopier.copy(disconnectSuccesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectSuccesses(String... disconnectSuccesses) {
            disconnectSuccesses(Arrays.asList(disconnectSuccesses));
            return this;
        }

        @Override
        public DisconnectPlayerResponse build() {
            return new DisconnectPlayerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
