/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.services.gamesparks.model.SectionModification;
import software.amazon.awssdk.services.gamesparks.model.SectionModificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameConfigurationRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, UpdateGameConfigurationRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(UpdateGameConfigurationRequest.getter(UpdateGameConfigurationRequest::gameName)).setter(UpdateGameConfigurationRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<List<SectionModification>> MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Modifications").getter(UpdateGameConfigurationRequest.getter(UpdateGameConfigurationRequest::modifications)).setter(UpdateGameConfigurationRequest.setter(Builder::modifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Modifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SectionModification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD, MODIFICATIONS_FIELD));
    private final String gameName;
    private final List<SectionModification> modifications;

    private UpdateGameConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.modifications = builder.modifications;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final boolean hasModifications() {
        return this.modifications != null && !(this.modifications instanceof SdkAutoConstructList);
    }

    public final List<SectionModification> modifications() {
        return this.modifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModifications() ? this.modifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameConfigurationRequest)) {
            return false;
        }
        UpdateGameConfigurationRequest other = (UpdateGameConfigurationRequest)((Object)obj);
        return Objects.equals(this.gameName(), other.gameName()) && this.hasModifications() == other.hasModifications() && Objects.equals(this.modifications(), other.modifications());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGameConfigurationRequest").add("GameName", (Object)this.gameName()).add("Modifications", this.hasModifications() ? this.modifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "Modifications": {
                return Optional.ofNullable(clazz.cast(this.modifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateGameConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String gameName;
        private List<SectionModification> modifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameConfigurationRequest model) {
            super(model);
            this.gameName(model.gameName);
            this.modifications(model.modifications);
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final List<SectionModification.Builder> getModifications() {
            List<SectionModification.Builder> result = SectionModificationListCopier.copyToBuilder(this.modifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModifications(Collection<SectionModification.BuilderImpl> modifications) {
            this.modifications = SectionModificationListCopier.copyFromBuilder(modifications);
        }

        @Override
        public final Builder modifications(Collection<SectionModification> modifications) {
            this.modifications = SectionModificationListCopier.copy(modifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifications(SectionModification ... modifications) {
            this.modifications(Arrays.asList(modifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifications(Consumer<SectionModification.Builder> ... modifications) {
            this.modifications(Stream.of(modifications).map(c -> (SectionModification)((SectionModification.Builder)SectionModification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameConfigurationRequest build() {
            return new UpdateGameConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGameConfigurationRequest> {
        public Builder gameName(String var1);

        public Builder modifications(Collection<SectionModification> var1);

        public Builder modifications(SectionModification ... var1);

        public Builder modifications(Consumer<SectionModification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

