/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlayerConnectionStatusRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, GetPlayerConnectionStatusRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(GetPlayerConnectionStatusRequest.getter(GetPlayerConnectionStatusRequest::gameName)).setter(GetPlayerConnectionStatusRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(GetPlayerConnectionStatusRequest.getter(GetPlayerConnectionStatusRequest::playerId)).setter(GetPlayerConnectionStatusRequest.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlayerId").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(GetPlayerConnectionStatusRequest.getter(GetPlayerConnectionStatusRequest::stageName)).setter(GetPlayerConnectionStatusRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("StageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD, PLAYER_ID_FIELD, STAGE_NAME_FIELD));
    private final String gameName;
    private final String playerId;
    private final String stageName;

    private GetPlayerConnectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.playerId = builder.playerId;
        this.stageName = builder.stageName;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final String playerId() {
        return this.playerId;
    }

    public final String stageName() {
        return this.stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlayerConnectionStatusRequest)) {
            return false;
        }
        GetPlayerConnectionStatusRequest other = (GetPlayerConnectionStatusRequest)((Object)obj);
        return Objects.equals(this.gameName(), other.gameName()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.stageName(), other.stageName());
    }

    public final String toString() {
        return ToString.builder((String)"GetPlayerConnectionStatusRequest").add("GameName", (Object)this.gameName()).add("PlayerId", (Object)this.playerId()).add("StageName", (Object)this.stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPlayerConnectionStatusRequest, T> g) {
        return obj -> g.apply((GetPlayerConnectionStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String gameName;
        private String playerId;
        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlayerConnectionStatusRequest model) {
            super(model);
            this.gameName(model.gameName);
            this.playerId(model.playerId);
            this.stageName(model.stageName);
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlayerConnectionStatusRequest build() {
            return new GetPlayerConnectionStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlayerConnectionStatusRequest> {
        public Builder gameName(String var1);

        public Builder playerId(String var1);

        public Builder stageName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

