/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.ListStagesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStagesResponse;
import software.amazon.awssdk.services.gamesparks.model.StageSummary;

public class ListStagesIterable
implements SdkIterable<ListStagesResponse> {
    private final GameSparksClient client;
    private final ListStagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStagesIterable(GameSparksClient client, ListStagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStagesResponseFetcher();
    }

    public Iterator<ListStagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StageSummary> stages() {
        Function<ListStagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stages() != null) {
                return response.stages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStagesResponseFetcher
    implements SyncPageFetcher<ListStagesResponse> {
        private ListStagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStagesResponse nextPage(ListStagesResponse previousPage) {
            if (previousPage == null) {
                return ListStagesIterable.this.client.listStages(ListStagesIterable.this.firstRequest);
            }
            return ListStagesIterable.this.client.listStages((ListStagesRequest)((Object)ListStagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

