/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse;

public class ListExtensionVersionsPublisher
implements SdkPublisher<ListExtensionVersionsResponse> {
    private final GameSparksAsyncClient client;
    private final ListExtensionVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExtensionVersionsPublisher(GameSparksAsyncClient client, ListExtensionVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExtensionVersionsPublisher(GameSparksAsyncClient client, ListExtensionVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExtensionVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExtensionVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExtensionVersionDetails> extensionVersions() {
        Function<ListExtensionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.extensionVersions() != null) {
                return response.extensionVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExtensionVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExtensionVersionsResponseFetcher
    implements AsyncPageFetcher<ListExtensionVersionsResponse> {
        private ListExtensionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExtensionVersionsResponse> nextPage(ListExtensionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionVersionsPublisher.this.client.listExtensionVersions(ListExtensionVersionsPublisher.this.firstRequest);
            }
            return ListExtensionVersionsPublisher.this.client.listExtensionVersions((ListExtensionVersionsRequest)((Object)ListExtensionVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

