/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.services.gamesparks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGameRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, CreateGameRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateGameRequest.getter(CreateGameRequest::clientToken)).setter(CreateGameRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateGameRequest.getter(CreateGameRequest::description)).setter(CreateGameRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(CreateGameRequest.getter(CreateGameRequest::gameName)).setter(CreateGameRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateGameRequest.getter(CreateGameRequest::tags)).setter(CreateGameRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, GAME_NAME_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String description;
    private final String gameName;
    private final Map<String, String> tags;

    private CreateGameRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.gameName = builder.gameName;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameRequest)) {
            return false;
        }
        CreateGameRequest other = (CreateGameRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.gameName(), other.gameName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGameRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("GameName", (Object)this.gameName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameRequest, T> g) {
        return obj -> g.apply((CreateGameRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String gameName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.gameName(model.gameName);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameRequest build() {
            return new CreateGameRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGameRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder gameName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

